indexing

	description:

		"EiffelTime DATE_TIME class interface"

	library:    "Gobo Eiffel Time Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 2000, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2000/06/02 19:19:41 $"
	revision:   "$Revision: 1.1 $"

class DATE_TIME

inherit

	ABSOLUTE
		undefine
			out
		end

	DATE_TIME_VALUE
		undefine
			append_date_to_string,
			append_time_to_string,
			append_precise_time_to_string
		end

	DATE
		rename
			make_from_storage as make_from_date_storage,
			make_from_day_count as make_date_from_day_count,
			storage as date_storage,
			make as make_date
		undefine
			hash_code, add,
			relative_duration,
			append_to_string,
			infix "<", out,
			canonical_duration,
			relative_date_duration
		redefine
			origin
		end

	TIME
		rename
			make_precise as make_precise_time,
			make_from_storage as make_from_time_storage,
			make_fine as make_fine_time,
			make as make_time,
			make_from_second_count as make_time_from_second_count,
			make_from_millisecond_count as make_time_from_millisecond_count,
			storage as time_storage
		undefine
			origin, hash_code,
			infix "<",
			add_milliseconds,
			add_minutes, add_hours,
			add, add_seconds,
			relative_duration,
			append_to_string,
			append_precise_to_string,
			precise_out, out, out_fine,
			canonical_duration,
			relative_time_duration
		end

	DT_DATE_TIME
		rename
			add_duration as add,
			duration as relative_duration,
			date_duration as relative_date_duration,
			time_duration as relative_time_duration,
			infix "-" as dt_infix_minus,
			Days_in_year as Days_in_non_leap_year,
			leap_year as i_th_leap_year,
			days_in_month as days_in_i_th_month
		export
			{ANY} make
		redefine
			relative_duration, date, time,
			relative_date_duration, relative_time_duration
		end

creation

	make, make_fine, make_by_date_time, make_by_date,
	make_precise, make_from_date_time, make_from_date

feature {NONE} -- Initialization

	make_fine (y, mo, d, h, mi: INTEGER; s: DOUBLE) is
			-- Set `year', `month' `day' to `y', `mo', `d'.
			-- Set `hour', `minute', `second' to `h', `m', `s'.
		require
			month_large_enough: mo >= 1
			month_small_enough: mo <= Months_in_year
			day_large_enough: d >= 1
			day_small_enough: d <= days_in_i_th_month (mo, y)
			h_large_enough: h >= 0
			h_small_enough: h < Hours_in_day
			m_large_enough: mi >= 0
			m_small_enough: mi < Minutes_in_hour
			s_large_enough: s >= 0
			s_small_enough: s < Seconds_in_minute
		do
			make_date (y, mo, d)
			make_precise_time (h, mi, s.truncated_to_integer,
				((s - second) * 1000).truncated_to_integer)
		ensure
			year_set: year = y
			month_set: month = mo
			day_set: day = d
			hour_set: hour = h
			minute_set: minute = mi
			second_set: second = s.truncated_to_integer
			millisecond_set: millisecond = ((s - second) * 1000).truncated_to_integer
		end

	make_by_date_time (d: DATE; t: TIME) is
			-- Set `date' to `d' and `time' to `t'.
		require
			d_exists: d /= Void
			t_exists: t /= Void
		do
			make_from_date_time (d, t)
		ensure
			date_set: date.is_equal (d)
			time_set: time.is_equal (t)
		end
 
feature -- Initialization

	make_by_date (d: DATE) is
			-- Set `date' to `d' and `time' to origin of time.
		require
			d_exists: d /= Void
		do
			make_from_date (d)
		ensure
			date_set: date.is_equal (d)
			time_set: time.is_equal (time.origin)
		end

feature -- Access

	origin: DATE_TIME is
			-- Origin date time
		once
			!! Result.make (1600, 1, 1, 0, 0, 0)
		end

	date: DATE is
			-- Date part
		do
			Result := Current
		end

	time: TIME is
			-- Time part
		do
			Result := Current
		end

	relative_duration (other: like Current): DATE_TIME_DURATION is
			-- Duration between `other' and current date time
		do
			!! Result.make_precise (0, 0, day_count - other.day_count,
				0, 0, 0, millisecond_count - other.millisecond_count)
		end

	definite_duration (other: like Current): DATE_TIME_DURATION is
			-- Duration between `other' and current date time
		require
			other_not_void: other /= Void
		do
			Result := relative_duration (other)
		ensure
			duration_not_void: Result /= Void
		end

	date_duration: DATE_DURATION is
			-- Definite duration between origin of date and current date time
		do
			Result := relative_date_duration (origin)
		end

	time_duration: TIME_DURATION is
			-- Duration elapsed from midnight of current date time
		do
			Result := relative_time_duration (origin)
		end

	relative_date_duration (other: like Current): DATE_DURATION is
			-- Duration between `other' and current date
		do
			!! Result.make (0, 0, day_count - other.day_count)
		end

	relative_time_duration (other: like Current): TIME_DURATION is
			-- Duration between `other' and current time
		do
			!! Result.make_precise (0, 0, 0, millisecond_count - other.millisecond_count)
		end

end -- class DATE_TIME
