/* 
   gy_procedures.c: gnu messenger procedures that are exported to
   guile environment
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdio.h>
#include <readline/readline.h>
#include <guile/gh.h>
#include <assert.h>

#include <sys/stat.h>

#include "gnuyahoo.h"
#include "messenger.h"
#include "extension.h"
#include "gy-utils.h"
#include "yahoo-wrapper.h"
#include "interpreter.h"
#include "scm-procedures.h"
#include <config.h>

/*
SCM
ex_set_some_thing_x (SCM scm_some_thing)
{
  int some_thing_length;
  
  // FIXME: currently I'm not validating the result of gh_scm2newstr
  // also note that Scheme strings may contain arbitrary data,
  // including null characters.  This means that null termination is
  // not a reliable way to determine the length of the returned value.
  // However, the function always copies the complete contents of
  // scm_some_thing, and sets *some_thing_length to the true length of the
  // string (when some_thing_length is non-null)
  
  set_some_thing (gh_scm2newstr (scm_some_thing, &some_thing_length));
  
  return SCM_UNSPECIFIED;
}
*/

/* returns current gnuyahoo version */
SCM
ex_version (void)
{
  return (gh_str02scm (VERSION));
}

/* this function should be used to print messages at run- time from the
   scheme environment 
*/
SCM
ex_display (SCM scm_message)
{
  //EX_PRINTF_MESSAGE (gh_scm2newstr (scm_message, NULL));
  printf ("%s\n",gh_scm2newstr (scm_message, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_toggle_x (SCM scm_what2toggle)
{

  if (strcasecmp (gh_scm2newstr (scm_what2toggle, NULL), "bell") == 0)
    toggle_bell ();
  else if (strcasecmp (gh_scm2newstr (scm_what2toggle, NULL), "who") == 0)
    toggle_who ();
  else if (strcasecmp (gh_scm2newstr (scm_what2toggle, NULL), "session") == 0)
    toggle_session ();
  else if (strcasecmp (gh_scm2newstr (scm_what2toggle, NULL), "status") == 0)
    toggle_status ();
  else
    // FIXME: I think this is now working!! 
    scm_wrong_type_arg (gh_scm2newstr (scm_what2toggle, NULL), 0,
			SCM_UNSPECIFIED);
  return SCM_UNSPECIFIED;
}

SCM
ex_hook_return (void)
{
  set_hook_return (1);
  return SCM_UNSPECIFIED;
}

SCM
ex_bell (void)
{
#if defined (HAVE_RL_DING)
  rl_ding ();
#else
#if defined (HAVE_DING)
  ding ();
#else
  /* don't worry, 'else' will never happen. configure script exits if both
     functions are missing */
  assert (0);
#endif
#endif
  return SCM_UNSPECIFIED;
}

SCM
ex_set_default_status_x (SCM scm_status)
{
  if (get_current_status () == -1)
    set_current_status (gh_scm2long (scm_status));
  return SCM_UNSPECIFIED;
}

SCM
ex_get_global_extensions_directory (void)
{
  return (gh_str02scm (get_global_extensions_directory ()));
}

SCM
ex_get_local_extensions_directory (void)
{
  return (gh_str02scm (get_local_extensions_directory ()));
}

SCM
ex_load (SCM scm_filename)
{
  gy_load (gh_scm2newstr (scm_filename, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_get_home_dir (void)
{
  return (gh_str02scm (get_home_directory ()));
}

SCM
ex_get_config_dir (void)
{
  return (gh_str02scm (get_config_directory ()));
}

SCM
ex_get_config_filename (void)
{
  return (gh_str02scm (get_config_filename ()));
}

SCM
ex_get_download_filename (void)
{
  return (gh_str02scm (get_download_filename ()));
}

SCM
ex_set_default_login_id_x (SCM scm_default_login_id)
{
  set_default_login_id (gh_scm2newstr (scm_default_login_id, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_get_default_login_id (void)
{
  return gh_str02scm (get_default_login_id ());
}

SCM
ex_set_default_password_x (SCM scm_default_password)
{
  set_default_password (gh_scm2newstr (scm_default_password, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_set_message_x (SCM scm_message)
{
  set_message (gh_scm2newstr (scm_message, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_set_message_to_x (SCM scm_message_to)
{
  set_message_to (gh_scm2newstr (scm_message_to, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_set_received_message_x (SCM scm_received_message)
{
  set_received_message (gh_scm2newstr (scm_received_message, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_set_received_message_from_x (SCM scm_received_message_from)
{
  set_received_message_from (gh_scm2newstr (scm_received_message_from, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_set_current_target_buddy_x (SCM scm_current_target_buddy)
{
  char *current_target_buddy = NULL;
  if (scm_current_target_buddy == SCM_BOOL_F)
    {
      set_current_target_buddy (NULL);
    }
  else
    {
      current_target_buddy = gh_scm2newstr (scm_current_target_buddy, NULL);
      
      if (current_target_buddy[0] == '\0')
	set_current_target_buddy (NULL);
      else
	set_current_target_buddy (current_target_buddy);
    }
  return SCM_UNSPECIFIED;
}

SCM
ex_send_message (SCM scm_to, SCM scm_message)
{
  send_message (gh_scm2newstr (scm_to, NULL),
		gh_scm2newstr (scm_message, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_send_message_no_hook (SCM scm_to, SCM scm_message)
{
  send_message_no_hook (gh_scm2newstr (scm_to, NULL),
			gh_scm2newstr (scm_message, NULL));
  return SCM_UNSPECIFIED;
}

SCM
ex_register_command_x (SCM command)
{
  register_command (command);
  return SCM_UNSPECIFIED;
}

SCM
ex_unregister_command_x (SCM command)
{
  unregister_command (command);
  return SCM_UNSPECIFIED;
}
