/* Jon Arney, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

/*
 * This is a representation
 * of an HTTP request.
 */
#ifndef PLAYER_H
#define PLAYER_H

typedef struct player_st {
  char *extension;
  char *mime_type;
  char *program;
} player_t;

#ifdef __cplusplus
extern "C" {
#endif

void play_init(void);
void player_add(char *mime_type, char *extension, char *program);
void player_play(char *mime_type, char *filename);
void player_foreach(int (*handler)(player_t *player, void *data), void *data);
void player_save(void);


#ifdef __cplusplus
}
#endif

#endif /*PLAYER_H*/
