/* window ops for context using the Xlib library.

   Copyright (C) 1999 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1999
   
   This file is part of the GNU Objective C User Interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifndef _XGContextWindow_h_INCLUDE
#define _XGContextWindow_h_INCLUDE

#define BOOL XWINDOWSBOOL	// prevent X windows BOOL
#include <X11/Xmd.h>		// warning
#undef BOOL
#include <gnustep/xgps/XGContext.h>

//
// WindowMaker window manager interaction
//
typedef struct {
    CARD32 flags;
    CARD32 window_style;
    CARD32 window_level;
    CARD32 reserved;
    Pixmap miniaturize_pixmap;		// pixmap for miniaturize button
    Pixmap close_pixmap;		// pixmap for close button
    Pixmap miniaturize_mask;		// miniaturize pixmap mask
    Pixmap close_mask;			// close pixmap mask
    CARD32 extra_flags;
} GNUstepWMAttributes;

#define GSWindowStyleAttr	(1<<0)
#define GSWindowLevelAttr	(1<<1)
#define GSMiniaturizePixmapAttr (1<<3)
#define GSClosePixmapAttr	(1<<4)
#define GSMiniaturizeMaskAttr	(1<<5)
#define GSCloseMaskAttr		(1<<6)
#define GSExtraFlagsAttr	(1<<7)

#define GSDocumentEditedFlag			(1<<0)
#define GSWindowWillResizeNotificationsFlag	(1<<1)
#define GSWindowWillMoveNotificationsFlag 	(1<<2)
#define GSNoApplicationIconFlag			(1<<5)
#define WMFHideOtherApplications		10
#define WMFHideApplication			12

typedef struct _gswindow_device_t {
  Display               *display;
  Window                ident;
  Window                root;
  Window		parent;
  int                   screen;
  GC                    gc;
  long                  number;
  int                   depth;
  int                   border;
  int			map_state;
  int                   visibility;
  NSBackingStoreType    type;
  NSRect                xframe;
  Drawable              buffer;
  Drawable              alpha_buffer;
  BOOL			is_exposed;
  NSMutableArray	*exposedRects;
  Region		region;		// Used between several expose events
  XWMHints		gen_hints;
  XSizeHints		siz_hints;
  GNUstepWMAttributes	win_attrs;
  XSetWindowAttributes	xwn_attrs;
  int			xoff;
  int			yoff;
  int			boff;
  Atom			protocols[4];
  int			numProtocols;
  XIC                   ic;
} gswindow_device_t;

#define GET_XDRAWABLE(win)  ((win)->buffer ? (win)->buffer: (win)->ident)                               

@interface XGContext (DPSWindow)
+ (gswindow_device_t *) _windowForXWindow: (Window)xWindow;
+ (gswindow_device_t *) _windowForXParent: (Window)xWindow;
+ (gswindow_device_t *) _windowWithTag: (int)windowNumber;
- (void) _addExposedRectangle: (XRectangle)rectangle : (int)win;
- (void) _processExposedRectangles: (int)win;
- (void) _initializeCursorForXWindow: (Window) win;
- (void) _destroyContextWindows;

/* This needs to go in NSGraphicsContext */
- (void) _DPSsetcursor: (Cursor)c : (BOOL)set;
@end

#endif
