/* XGContextPrivate - Private definitinos for XGContext files.

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1998
   
   This file is part of the GNU Objective C User Interface Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifndef _XGContextPrivate_h_INCLUDE
#define _XGContextPrivate_h_INCLUDE

#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSException.h>
#include <Foundation/NSObjCRuntime.h>
#include <AppKit/GSFontInfo.h>

/* Font function (defined in XGFontManager) */
extern NSString	*XGXFontName(NSString *fontName, float size);

/* Font functions (defined in XGCommonFont) */
extern NSString *XGFontName(Display *dpy, XFontStruct *font_struct);
extern NSString	*XGFontFamily(Display *dpy, XFontStruct *font_struct);
extern float XGFontPointSize(Display *dpy, XFontStruct *font_struct);
extern int XGWeightOfFont(Display *dpy, XFontStruct *info);
extern NSFontTraitMask XGTraitsOfFont(Display *dpy, XFontStruct *info);
extern BOOL XGFontIsFixedPitch(Display *dpy, XFontStruct *font_struct);
extern NSString *XGFontPropString(Display *dpy, XFontStruct *font_struct, 
				  Atom atom);
extern unsigned long XGFontPropULong(Display *dpy, XFontStruct *font_struct, 
			      Atom atom);

@interface XGFontEnumerator : GSFontEnumerator
{
}
@end

@interface XGFontInfo : GSFontInfo
{
  XFontStruct *font_info;
}
@end

@interface GSFontInfo (XBackend)

- (void) drawString:  (NSString*)string
	  onDisplay: (Display*) xdpy drawable: (Drawable) draw
	       with: (GC) xgcntxt at: (XPoint) xp;
- (void) draw: (const char*) s lenght: (int) len 
    onDisplay: (Display*) xdpy drawable: (Drawable) draw
	 with: (GC) xgcntxt at: (XPoint) xp;
- (float) widthOf: (const char*) s lenght: (int) len;
- (void) setActiveFor: (Display*) xdpy gc: (GC) xgcntxt;

@end

/* Error Macros */
#define DPS_ERROR(type, resp, args...)		\
  do {						\
    NSDebugLLog(@"XGContext", resp, ## args );	\
    return;					\
  } while (0)

#define DPS_FATAL(type, resp, args...) \
    [NSException raise: type format: resp, ## args]

/* Current keys used for the info dictionary:
       Key:           Value:
     DisplayName  -- (NSString)name of X server
     ScreenNumber -- (NSNumber)screen number
     ContextData  -- (NSData)context data
     DebugContext -- (NSNumber)YES or NO
*/

extern NSString *DPSconfigurationerror;
extern NSString *DPSinvalidaccess;
extern NSString *DPSinvalidcontext;
extern NSString *DPSinvalidexit;
extern NSString *DPSinvalidfileaccess;
extern NSString *DPSinvalidfont;
extern NSString *DPSinvalidid;
extern NSString *DPSinvalidrestore;
extern NSString *DPSinvalidparam;
extern NSString *DPSioerror;
extern NSString *DPSlimitcheck;
extern NSString *DPSnocurrentpoint;
extern NSString *DPSnulloutput;
extern NSString *DPSrangecheck;
extern NSString *DPSstackoverflow;
extern NSString *DPSstackunderflow;
extern NSString *DPStypecheck;
extern NSString *DPSundefined;
extern NSString *DPSundefinedfilename;
extern NSString *DPSundefinedresource;
extern NSString *DPSundefinedresult;
extern NSString *DPSunmatchedmark;
extern NSString *DPSunregistered;
extern NSString *DPSVMerror;

#endif
