/* 
   NSSecureTextField.h

   Secure text field control class for hidden text entry

   Copyright (C) 1999 Free Software Foundation, Inc.

   Author: Lyndon Tremblay <humasect@coolmail.com>
   Date: 1999
   
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_NSSecureTextField
#define _GNUstep_H_NSSecureTextField

#include <AppKit/NSTextField.h>
#include <AppKit/NSTextFieldCell.h>

@class NSNotification;
@class NSColor;
@class NSText;
@class NSCursor;

@interface NSSecureTextField : NSTextField
{
}
@end

@interface NSSecureTextFieldCell : NSTextFieldCell
{
  BOOL i_echosBullets;
}
- (void)setEchosBullets:(BOOL)flag;
- (BOOL)echosBullets;
@end

#endif /* _GNUstep_H_NSSecureTextField */
