/*
   NSTabViewItem.h
   
   Copyright (C) 1996 Free Software Foundation, Inc.
  
   Author:  Michael Hanni <mhanni@sprintmail.com>
   Date: 1999
  
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef _GNUstep_H_NSTabViewItem
#define _GNUstep_H_NSTabViewItem

#include <AppKit/NSTabView.h>

typedef enum {
  NSSelectedTab = 0,
  NSBackgroundTab,
  NSPressedTab
} NSTabState;

@class NSColor;

@interface NSTabViewItem : NSObject <NSCoding>
{
  id _ident;
  NSString *_label;
  NSView *_view;
  NSColor *_color;
  NSTabState _state;
  NSView *_first_responder;
  NSTabView *_tabview;
  NSRect _rect; // cached
}
- (id) initWithIdentifier:(id)identifier;

- (void)setIdentifier:(id)identifier;
- (id)identifier;

- (void)setLabel:(NSString *)label;
- (NSString *)label;
- (NSSize)sizeOfLabel:(BOOL)shouldTruncateLabel;

- (void)setView:(NSView *)view;
- (NSView *)view;

- (void)setColor:(NSColor *)color;
- (NSColor *)color;

- (NSTabState)tabState;
- (NSTabView *)tabView;

- (void)setInitialFirstResponder:(NSView *)view;
- (id)initialFirstResponder;

- (void)drawLabel:(BOOL)shouldTruncateLabel
           inRect:(NSRect)tabRect;
@end

@interface NSTabViewItem (GNUstep)

// Non-spec
- (void)_setTabState:(NSTabState)tabState;
- (void)_setTabView:(NSTabView *)tabView;
- (NSRect) _tabRect;
- (NSString*)_truncatedLabel;
@end

#endif // _GNUstep_H_NSTabViewItem

