/*
**  ViewingView.m
**
**  Copyright (c) 2001-2004
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ViewingView.h"

#include "Constants.h"
#include "LabelWidget.h"


//
//
//
@implementation ViewingView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}


//
//
//
- (void) dealloc
{
  NSDebugLog(@"ViewingView: -dealloc");

  RELEASE(hideDeletedMessages);
  RELEASE(hideReadMessages);
  RELEASE(highlightURLs);
  RELEASE(doubleClickPopUpButton);
  
  [super dealloc];
}


//
//
//
- (void) layoutView
{
  LabelWidget *label, *doubleClickLabel;
  NSButton *headersButton;
  NSBox *box;

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,195,430,35)
		       label: _(@"In this panel, you can specify some message viewing options and\nalso which table colums you want to see in the message list.")];
  [self addSubview: label];

  //
  // Our messages box
  //
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,80,430,105)];
  [box setTitlePosition: NSAtTop];
  [box setTitle: _(@"Messages")];
  [box setBorderType: NSGrooveBorder];

  hideDeletedMessages = [[NSButton alloc] initWithFrame: NSMakeRect(5,55,400,ButtonHeight)];
  [hideDeletedMessages setButtonType: NSSwitchButton];
  [hideDeletedMessages setBordered: NO];
  [hideDeletedMessages setTitle: _(@"Hide deleted messages on startup")];
  [[box contentView] addSubview: hideDeletedMessages];

  hideReadMessages = [[NSButton alloc] initWithFrame: NSMakeRect(5,30,400,ButtonHeight)];
  [hideReadMessages setButtonType: NSSwitchButton];
  [hideReadMessages setBordered: NO];
  [hideReadMessages setTitle: _(@"Hide read messages on startup")];
  [[box contentView] addSubview: hideReadMessages];
  
  highlightURLs = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,400,ButtonHeight)];
  [highlightURLs setButtonType: NSSwitchButton];
  [highlightURLs setBordered: NO];
  [highlightURLs setTitle: _(@"Highlight URLs in message content")];
  [[box contentView] addSubview: highlightURLs];

  [self addSubview: box];
  RELEASE(box);
  
  //
  // Our label/button to set the visible headers
  //
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,35,385,TextFieldHeight)
		       label: _(@"To specify the list of visible headers when viewing a message, click here")];
  [self addSubview: label];
    
  headersButton = [[NSButton alloc] initWithFrame: NSMakeRect(395,33,40,ButtonHeight)];
  [headersButton setStringValue: _(@"Set")];
  [headersButton setTarget: parent];
  [headersButton setAction:@selector(headersButtonClicked:)];
  [self addSubview: headersButton];
  RELEASE(headersButton);


  //
  //
  //
  doubleClickLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,5,170,TextFieldHeight)
				  label: _(@"Double-clicking in message list opens") ];
  [self addSubview: doubleClickLabel];

  doubleClickPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(185,3,250,ButtonHeight)];
  [doubleClickPopUpButton setAutoenablesItems: NO];
  [doubleClickPopUpButton addItemWithTitle: _(@"opens reply editor")];
  [doubleClickPopUpButton addItemWithTitle: _(@"opens message in new window")];
  [doubleClickPopUpButton addItemWithTitle: _(@"does nothing")];
  [self addSubview: doubleClickPopUpButton];
}

@end
