/*
**  TextEnrichedConsumer.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

// Parameter Command
#define PARAM          @"<param>"
#define PARAM_END      @"</param>"

// Font-Alteration Commands
#define BIGGER         @"<bigger>"
#define BIGGER_END     @"</bigger>"
#define BOLD           @"<bold>"
#define BOLD_END       @"</bold>"
#define COLOR          @"<color>"
#define COLOR_END      @"</color>"
#define FIXED          @"<fixed>"
#define FIXED_END      @"</fixed>"
#define FONTFAMILY     @"<fontfamily>"
#define FONTFAMILY_END @"</fontfamily>"
#define ITALIC         @"<italic>"
#define ITALIC_END     @"</italic>"
#define SMALLER        @"<smaller>"
#define SMALLER_END    @"</smaller>"
#define UNDERLINE      @"<underline>"
#define UNDERLINE_END  @"</underline>"

// Fill / Justification / Indentation Commands
#define CENTER         @"<center>"
#define CENTER_END     @"</center>"
#define FLUSHLEFT      @"<flushleft>"
#define FLUSHLEFT_END  @"</flushleft>"
#define FLUSHRIGHT     @"<flushright>"
#define FLUSHRIGHT_END @"</flushright>"
#define IN             @"<in>"
#define IN_END         @"</in>"
#define LEFT           @"<left>"
#define LEFT_END       @"</left>"
#define NOFILL         @"<nofill>"
#define NOFILL_END     @"</nofill>"
#define OUT            @"<out>"
#define OUT_END        @"</out>"
#define PARAINDENT     @"<paraindent>"
#define PARAINDENT_END @"</paraindent>"
#define RIGHT          @"<right>"
#define RIGHT_END      @"</right>"

// Markup Commands
#define EXCERPT        @"<excerpt>"
#define EXCERPT_END    @"</excerpt>"
#define LANG           @"<lang>"
#define LANG_END       @"</lang>"

@interface TextEnrichedConsumer : NSObject
{

}

+ (NSAttributedString *) attributedStringFromTextEnrichedString: (NSString *) theString;

+ (void) _alterAttributedString: (NSMutableAttributedString *) theMutableAttributedString
		    withScanner: (NSScanner *) theScanner
		    fontManager: (NSFontManager *) theFontManager
		       startCmd: (NSString *) theStartCmd
			 endCmd: (NSString *) theEndCmd
                          trait: (int) theTrait;

+ (void) _removeCommandsFromAttributedString: (NSMutableAttributedString *) theMutableAttributedString;

+ (void) _unfoldAttributedString: (NSMutableAttributedString *) theMutableAttributedString;

@end
