/*
**  NewMailboxPanelController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class MailboxManagerController;

@interface NewMailboxPanelController: NSWindowController
{
  // Outlets
  IBOutlet NSTextField *mailboxNameField;
  
  // Other ivar
  NSString *name, *path;
  MailboxManagerController *mailboxManagerController;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// action methods
//

- (IBAction) okClicked: (id) sender;
- (IBAction) cancelClicked: (id) sender;

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification;

//
// access/mutation methods
//

- (MailboxManagerController *) mailboxManagerController;
- (void) setMailboxManagerController: (MailboxManagerController *) theMailboxManagerController;

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (NSString *) path;
- (void) setPath: (NSString *) thePath;

@end

