/*
**  NSRegExRange.m
**
**  Copyright (c) 2001
**
**  Author: Francis Lachapelle <francis@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "NSRegExRange.h"

#import "GNUMailConstants.h"

@implementation NSRegExRange


- (id) init
{
  self = [super init];

  return self;
}


- (id) initWithRangeLocation: (int) location
                      length: (int) length
{
  self = [super init];
  
  range = NSMakeRange(location, length);

  return self;
}


- (id) initWithRangeStart: (int) indexStart
                      end: (int) indexEnd
{
  self = [super init];
  
  range = NSMakeRange(indexStart, indexEnd - indexStart);

  return self;
}


- (int) location
{
  return range.location;
}


- (NSRange) range
{
  return range;
}

@end
