/*
**  FindWindowController.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "FindWindowController.h"

#ifndef MACOSX
#import "FindWindow.h"
#endif

#import "GNUMail.h"
#import "GNUMailConstants.h"
#import "MailWindowController.h"
#import "NSRegEx.h"
#import "NSRegExRange.h"
#import "NSStringExtensions.h"

#import <Pantomime/Folder.h>
#import <Pantomime/Message.h>

static FindWindowController *singleInstance = nil;

@implementation FindWindowController


- (id) initWithWindowNibName: (NSString *) windowNibName
{
#ifdef MACOSX
  
  self = [super initWithWindowNibName: windowNibName];
 
#else
  FindWindow *theWindow;
  
  theWindow = [[FindWindow alloc] initWithContentRect: NSMakeRect(200,200,440,205)
				  styleMask: (NSTitledWindowMask |
					      NSClosableWindowMask |
					      NSMiniaturizableWindowMask)
				  backing: NSBackingStoreBuffered
				  defer: YES];
  
  [super initWithWindow: theWindow];

  [theWindow layoutWindow];
  [theWindow setDelegate: self];
  [theWindow setMinSize: [theWindow frame].size];

  // We link our outlets
  findField = [theWindow findField];
  replaceWithField = [theWindow replaceWithField];
  foundLabel = [theWindow foundLabel];
  ignoreCaseButton = [theWindow ignoreCaseButton];
  regularExpressionButton = [theWindow regularExpressionButton];
  matrix = [theWindow matrix];

  RELEASE(theWindow);
#endif

  [[self window] setTitle: _(@"Find")];

  return self;
}

- (void) dealloc
{
  RELEASE(indexes);
  
  [super dealloc];
}


//
// action methods
//

- (IBAction) findAll: (id) sender
{
  NSString *searchString, *subject;
  
  NSArray *allMessages;
  NSTableView *tableView;
  
  Message *message;
  
  NSRange range;
  int i, previous_row_selected, results_found;

  location = 0;
  searchString = [findField stringValue];
  
  if ( [GNUMail lastMailWindowOnTop] && 
       ([[searchString stringByTrimmingWhiteSpaces] length] > 0)) 
    {
      MailWindowController *mailWindowController;

      mailWindowController = (MailWindowController *)[[GNUMail lastMailWindowOnTop] delegate];
      
      allMessages = [[mailWindowController folder] allMessages];
      tableView = [mailWindowController tableView];

      previous_row_selected = [tableView selectedRow];

      [indexes removeAllObjects];
      results_found = 0;
      
      [tableView deselectAll: nil];
      
      for (i = 0; i < [allMessages count]; i++)
	{
	  message = [allMessages objectAtIndex: i];
	  subject = [message subject];
	  
	  if ( subject )
	    {
	      if ( [regularExpressionButton state] == NSOnState )
		{
		  NSArray *anArray;
		  
		  anArray = [NSRegEx matchString: subject
				     withPattern : searchString
				     isCaseSensitive: ([ignoreCaseButton state] == NSOffState)];
		  
		  if ( [anArray count] > 0 )
		    {
		      results_found += 1;
		      [tableView selectRow:i byExtendingSelection:YES];
		      [indexes addObject: [NSNumber numberWithInt: i]];
		    }
		}
	      else
		{
		  if ( [ ignoreCaseButton state] == NSOnState )
		    {
		      range = [subject rangeOfString: searchString
				       options: NSCaseInsensitiveSearch]; 
		    }
		  else
		    {
		      range = [subject rangeOfString: searchString]; 
		    }
		  
		  if ( range.location != NSNotFound )
		    {
		      results_found += 1;
		      [tableView selectRow:i byExtendingSelection:YES];
		      [indexes addObject: [NSNumber numberWithInt: i]];
		    }
		} // if ( [regularExpressionButton state] == NSOnState )
	    }
	}
      
      if ( results_found == 0 )
	{
	  NSBeep();
	  [tableView selectRow: previous_row_selected byExtendingSelection:NO];
	}
      else if ( results_found == 1)
	{
	  [tableView scrollRowToVisible: [[indexes objectAtIndex:0] intValue]];
	}
      
      [self updateLabel: foundLabel
	    withValue: results_found];
      
      [tableView setNeedsDisplay:YES];
    }
}

- (IBAction) nextMessage: (id) sender
{
  if ( [GNUMail lastMailWindowOnTop] )
    {
      MailWindowController *mailWindowController;
      NSTableView *tableView; 

      mailWindowController = (MailWindowController *)[[GNUMail lastMailWindowOnTop] delegate];
      
      tableView = [mailWindowController tableView];

      if ([indexes count] < 2)
	{
	  NSBeep();
	  return;
	}
      else
	{
	  [tableView selectRow:[[indexes objectAtIndex:location] intValue] byExtendingSelection:NO];
	  [tableView scrollRowToVisible:[[indexes objectAtIndex:location] intValue] ];
	  location += 1;
	  
	  if (location == [indexes count])
	    {
	      location = 0;
	    }

	  [tableView setNeedsDisplay:YES];
	}
    }
}

- (IBAction) previousMessage: (id) sender
{
  
  if ( [GNUMail lastMailWindowOnTop] )
    {
      MailWindowController *mailWindowController;
      NSTableView *tableView; 
      
      mailWindowController = (MailWindowController *)[[GNUMail lastMailWindowOnTop] delegate];
      
      tableView = [mailWindowController tableView];
      
      if ([indexes count] < 2)
	{
	  NSBeep();
	  return;
	}
      else
	{
	  [tableView selectRow:[[indexes objectAtIndex:location] intValue]  byExtendingSelection:NO];
	  [tableView scrollRowToVisible:[[indexes objectAtIndex:location] intValue] ];
	  location -= 1;
	  
	  if (location < 0)
	    {
	      location = [indexes count] - 1;
	    }

	  [tableView setNeedsDisplay:YES];
	}
    }
}

//
// delegate methods
//

- (void) windowDidLoad
{
  indexes = [[NSMutableArray alloc] init];
}

//
// access / mutation
//
- (void) updateLabel: (NSTextField *) theLabel
           withValue: (int) theValue
{
  [theLabel setStringValue: [NSString stringWithFormat: @"%i found", theValue]];
}

- (NSTextField *) findField
{
  return findField;
}

//
// class methods
//

+ (id) singleInstance
{
  if ( ! singleInstance )
    {
      singleInstance = [[self alloc] initWithWindowNibName: @"FindWindow"];
    }
  return singleInstance;
}

@end
