/*
**  FindWindow.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "FindWindow.h"

#import "GNUMailConstants.h"

@implementation FindWindow

- (void) dealloc
{
  RELEASE(findField);
  RELEASE(replaceWithField);
  RELEASE(matrix);
  RELEASE(ignoreCaseButton);
  RELEASE(regularExpressionButton);
  
  [super dealloc];
}

- (void) layoutWindow
{
  NSButton *findAllButton;
  NSButton *replaceButton;
  NSButton *replaceAndFindButton;
  NSButton *previousButton;
  NSButton *nextButton;
  LabelWidget *findLabel;
  LabelWidget *replaceWithLabel;
  NSBox *box;
  NSButtonCell *cell;
  

  findLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(60,175,30,TextFieldHeight)
			   label: _(@"Find:") ];
  [[self contentView] addSubview: findLabel];
  
  findField = [[NSTextField alloc] initWithFrame: NSMakeRect(95,175,330, TextFieldHeight)];
  [findField setStringValue:@""];
  [[self contentView] addSubview: findField];

  replaceWithLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(15,145,75,TextFieldHeight)
				  label: _(@"Replace with:") ];
  [[self contentView] addSubview: replaceWithLabel];

  replaceWithField = [[NSTextField alloc] initWithFrame: NSMakeRect(95,145,330, TextFieldHeight)];

  [[self contentView] addSubview: replaceWithField];
  
  box = [[NSBox alloc] initWithFrame: NSMakeRect(95,50,160,80)];
  [box setContentViewMargins: NSMakeSize(5,5)];
  AUTORELEASE(box);
  [box setTitle: _(@"Find Scope")];
  [box setTitleFont: [NSFont boldSystemFontOfSize: 12]];
  [box setTitlePosition: NSAtTop];
  [box setBorderType: NSGrooveBorder];
  [[self contentView] addSubview: box];

  
  cell = [[NSButtonCell alloc] init];
  [cell setButtonType: NSRadioButton];
  [cell setBordered: NO];
  [cell setImagePosition: NSImageLeft];

  matrix = [[NSMatrix alloc] initWithFrame: NSZeroRect
			     mode: NSRadioModeMatrix
			     prototype: cell
			     numberOfRows: 2
			     numberOfColumns: 1];
  [matrix setTarget: [self windowController]];
  [matrix setIntercellSpacing: NSMakeSize (0, 10) ];
  [matrix setAutosizesCells: NO];

  cell = [matrix cellAtRow: 0 column: 0];
  [cell setTitle: _(@"Summaries")];

  cell = [matrix cellAtRow: 1 column: 0];
  [cell setTitle: _(@"Messages")];

  [matrix sizeToFit];  
  [[box contentView] addSubview: matrix];

  box = [[NSBox alloc] initWithFrame: NSMakeRect(265,50,160,80)];
  [box setContentViewMargins: NSMakeSize(0,0)];
  AUTORELEASE(box);
  [box setTitle: _(@"Find Options")];
  [box setTitleFont: [NSFont boldSystemFontOfSize: 12]];
  [box setTitlePosition: NSAtTop];
  [box setBorderType: NSGrooveBorder];
  [[self contentView] addSubview: box];
  
  ignoreCaseButton = [[NSButton alloc] initWithFrame: NSMakeRect(5,25,140,ButtonHeight)];
  AUTORELEASE(ignoreCaseButton);
  [ignoreCaseButton setTitle: _(@"Ignore Case")];
  [ignoreCaseButton setButtonType: NSSwitchButton];
  [ignoreCaseButton setBordered: NO];
  [[box contentView] addSubview: ignoreCaseButton];

  regularExpressionButton = [[NSButton alloc] initWithFrame: NSMakeRect(5,0,140,ButtonHeight)];
  AUTORELEASE(regularExpressionButton);
  [regularExpressionButton setTitle: _(@"Regular Expression")];
  [regularExpressionButton setButtonType: NSSwitchButton];
  [regularExpressionButton setBordered: NO];
  [[box contentView] addSubview: regularExpressionButton];

  findAllButton = [[NSButton alloc] initWithFrame: NSMakeRect(10,10,75,ButtonHeight)];
  AUTORELEASE(findAllButton);
  [findAllButton setStringValue: _(@"Find All")];
  [findAllButton setTarget: [self windowController]];
  [findAllButton setAction: @selector(findAll:) ];
  [[self contentView] addSubview: findAllButton];

  replaceButton = [[NSButton alloc] initWithFrame: NSMakeRect(90,10,75,ButtonHeight)];
  AUTORELEASE(replaceButton);
  [replaceButton setStringValue: _(@"Replace")];
  [[self contentView] addSubview: replaceButton];

  replaceAndFindButton = [[NSButton alloc] initWithFrame: NSMakeRect(170,10,100,ButtonHeight)];
  AUTORELEASE(replaceAndFindButton);
  [replaceAndFindButton setStringValue: _(@"Replace & Find")];
  [[self contentView] addSubview: replaceAndFindButton];

  previousButton = [[NSButton alloc] initWithFrame: NSMakeRect(275,10,75,ButtonHeight)];
  AUTORELEASE(previousButton);
  [previousButton setStringValue: _(@"Previous")];
  [previousButton setTarget: [self windowController]];
  [previousButton setAction: @selector(previousMessage:)];
  [[self contentView] addSubview: previousButton];

  nextButton = [[NSButton alloc] initWithFrame: NSMakeRect(355,10,75,ButtonHeight)];
  AUTORELEASE(nextButton);
  [nextButton setStringValue: _(@"Next")];
  [nextButton setTarget: [self windowController]];
  [nextButton setAction: @selector(nextMessage:)];
  [[self contentView] addSubview: nextButton];


  foundLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(15,80,50,TextFieldHeight)
			    label: @"" ];
  [foundLabel setTextColor:[NSColor darkGrayColor]];

  [[self contentView] addSubview: foundLabel];

  // FIXME - When find & replace will be implemented (and other stuff), uncomment the following lines
  [replaceButton setEnabled: NO];
  [replaceAndFindButton setEnabled: NO];
}

//
// access/mutation methods
//

- (NSTextField *) findField
{
  return findField;
}

- (NSTextField *) replaceWithField
{
  return replaceWithField;
}

- (NSButton *) ignoreCaseButton
{
  return ignoreCaseButton;
}

- (NSButton *) regularExpressionButton
{
  return regularExpressionButton;
}

- (LabelWidget *) foundLabel
{
  return foundLabel;
}

- (NSMatrix *) matrix
{
  return matrix;
}

@end

