/*
**  Filter.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "Filter.h"

#import "GNUMailConstants.h"

static int currentVersion = 1;

@implementation Filter

//
//
//

- (id) init
{
  self = [super init];

  [Filter setVersion: currentVersion];

  [self setIsActive: YES];
  [self setDescription: @""];
  [self setCriteriaSource: TO];
  [self setCriteriaHeaders: [NSArray array]];
  [self setCriteriaFindOperation: CONTAINS];
  [self setCriteriaString: @""];

  [self setAction: SET_COLOR];
  [self setActionColor: [NSColor lightGrayColor]];
  [self setActionFolderName: @""];
  [self setActionEMailOperation: BOUNCE];
  [self setActionEMailString: @""];
  [self setActionMessageString: @""];

  return self;
}

- (void) dealloc
{
  RELEASE(description);
  RELEASE(criteriaString);
  RELEASE(actionColor);
  RELEASE(actionFolderName);
  RELEASE(actionEMailString);
  RELEASE(actionMessageString);

  [super dealloc];
}

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [Filter setVersion: currentVersion];

  [theCoder encodeObject: [NSNumber numberWithBool: [self isActive]] ];
  [theCoder encodeObject: [self description] ];
  [theCoder encodeObject: [NSNumber numberWithInt: [self criteriaSource]] ];
  [theCoder encodeObject: [self criteriaHeaders] ];
  [theCoder encodeObject: [NSNumber numberWithInt: [self criteriaFindOperation]] ];
  [theCoder encodeObject: [self criteriaString] ];
  
  [theCoder encodeObject: [NSNumber numberWithInt: [self action]] ];
  [theCoder encodeObject: [self actionColor] ];
  [theCoder encodeObject: [self actionFolderName] ];
  [theCoder encodeObject: [NSNumber numberWithInt: [self actionEMailOperation]] ];
  [theCoder encodeObject: [self actionEMailString] ];
  [theCoder encodeObject: [self actionMessageString] ];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  int version;
  
  version = [theCoder versionForClassName: NSStringFromClass([self class])];
  //NSLog(@"Filter's Version number = %d", version);

  self = [super init];
  
  // Initial version of the serialized filter object
  if ( version == 0 )
    {
      [self setIsActive: [[theCoder decodeObject] boolValue] ];
      [self setDescription: [theCoder decodeObject] ];
      [self setCriteriaSource: [[theCoder decodeObject] intValue] ];
      [self setCriteriaFindOperation: [[theCoder decodeObject] intValue] ];
      [self setCriteriaString: [theCoder decodeObject] ];
      
      [self setAction: [[theCoder decodeObject] intValue] ];
      [self setActionColor: [theCoder decodeObject] ];
      [self setActionFolderName: [theCoder decodeObject] ];
      [self setActionEMailOperation: [[theCoder decodeObject] intValue]];
      [self setActionEMailString: [theCoder decodeObject] ];
      [self setActionMessageString: [theCoder decodeObject] ];

      // We set default values for our new properties
      [self setCriteriaHeaders: [NSArray array]];
    }
  // Version 1
  else
    {
      [self setIsActive: [[theCoder decodeObject] boolValue] ];
      [self setDescription: [theCoder decodeObject] ];
      [self setCriteriaSource: [[theCoder decodeObject] intValue] ];
      [self setCriteriaHeaders: [theCoder decodeObject] ];
      [self setCriteriaFindOperation: [[theCoder decodeObject] intValue] ];
      [self setCriteriaString: [theCoder decodeObject] ];
      
      [self setAction: [[theCoder decodeObject] intValue] ];
      [self setActionColor: [theCoder decodeObject] ];
      [self setActionFolderName: [theCoder decodeObject] ];
      [self setActionEMailOperation: [[theCoder decodeObject] intValue]];
      [self setActionEMailString: [theCoder decodeObject] ];
      [self setActionMessageString: [theCoder decodeObject] ]; 
    }

  return self;
}

//
// NSCopying protocol
//
- (id) copyWithZone: (NSZone *) zone
{
  Filter *aFilter;

  aFilter = [[Filter alloc] init];

  [aFilter setIsActive: [self isActive] ];
  [aFilter setDescription: [self description] ];
  [aFilter setCriteriaSource: [self criteriaSource] ];
  [aFilter setCriteriaHeaders: [self criteriaHeaders] ];
  [aFilter setCriteriaFindOperation: [self criteriaFindOperation] ];
  [aFilter setCriteriaString: [self criteriaString] ];

  [aFilter setAction: [self action] ];
  [aFilter setActionColor: [self actionColor] ];
  [aFilter setActionFolderName: [self actionFolderName] ];
  [aFilter setActionEMailOperation: [self actionEMailOperation] ];
  [aFilter setActionEMailString: [self actionEMailString] ];
  [aFilter setActionMessageString: [self actionMessageString] ];

  return aFilter;
}

//
// access/mutation methods
//

- (BOOL) isActive
{
  return isActive;
}


- (void) setIsActive: (BOOL) theBOOL
{
  isActive = theBOOL;
}


- (NSString *) description
{
  return description;
}

- (void) setDescription: (NSString *) theDescription
{
  RETAIN(theDescription);
  RELEASE(description);
  description = theDescription;
}

- (int) criteriaSource
{
  return criteriaSource;
}

- (void) setCriteriaSource: (int) theCriteriaSource
{
  criteriaSource = theCriteriaSource;
}

- (NSArray *) criteriaHeaders
{
  return criteriaHeaders;
}

- (void) setCriteriaHeaders: (NSArray *) theCriteriaHeaders
{
  RETAIN(theCriteriaHeaders);
  RELEASE(criteriaHeaders);
  criteriaHeaders = theCriteriaHeaders;
}

- (int) criteriaFindOperation
{
  return criteriaFindOperation;
}

- (void) setCriteriaFindOperation: (int) theCriteriaFindOperation
{
  criteriaFindOperation = theCriteriaFindOperation;
}

- (NSString *) criteriaString
{
  return criteriaString;
}

- (void) setCriteriaString: (NSString *) theCriteriaString
{
  RETAIN(theCriteriaString);
  RELEASE(criteriaString);
  criteriaString = theCriteriaString;
}

- (int) action
{
  return action;
}

- (void) setAction: (int) theAction
{
  action = theAction;
}

- (NSColor *) actionColor
{
  return actionColor;
}

- (void) setActionColor: (NSColor *) theActionColor
{
  RETAIN(theActionColor);
  RELEASE(actionColor);
  actionColor = theActionColor;
}

- (NSString *) actionFolderName
{
  return actionFolderName;
}

- (void) setActionFolderName: (NSString *) theActionFolderName
{
  RETAIN(theActionFolderName);
  RELEASE(actionFolderName);
  actionFolderName = theActionFolderName;
}

- (int) actionEMailOperation
{
  return actionEMailOperation;
}

- (void) setActionEMailOperation: (int) theActionEMailOperation
{
  actionEMailOperation = theActionEMailOperation;
}

- (NSString *) actionEMailString
{
  return actionEMailString;
}

- (void) setActionEMailString: (NSString *) theActionEMailString
{
  RETAIN(theActionEMailString);
  RELEASE(actionEMailString);
  actionEMailString = theActionEMailString;
}

- (NSString *) actionMessageString
{
  return actionMessageString;
}

- (void) setActionMessageString: (NSString *) theActionMessageString
{
  RETAIN(theActionMessageString);
  RELEASE(actionMessageString);
  actionMessageString = theActionMessageString;
}



//
// class methods
//


@end
