/*
**  TransportMethodEditorWindowController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@interface TransportMethodEditorWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSPopUpButton *transportMethodPopUpButton;
  
  IBOutlet NSTextField *mailerField;

  IBOutlet NSTextField *smtpHostField;
  IBOutlet NSTextField *smtpUsernameField;
  IBOutlet NSSecureTextField *smtpPasswordSecureField;
  IBOutlet NSButton *rememberPassword;

  IBOutlet NSButton *authenticateUsingButton;
  IBOutlet NSButton *supportedMechanismsButton;
  IBOutlet NSPopUpButton *supportedMechanismsPopUp;

  IBOutlet NSPopUpButton *personalProfilePopUpButton;

  IBOutlet NSButton *cancelButton, *okButton;

  // Other ivar
  NSMutableDictionary *transportMethod;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// action methods
//

- (IBAction) okClicked: (id) sender;
- (IBAction) cancelClicked: (id) sender;
- (IBAction) transportMethodHasChanged: (id) sender;
- (IBAction) supportedMechanismsButtonClicked: (id) sender;
- (IBAction) authenticateUsingButtonClicked: (id) sender;

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification;

//
// access/mutation methods
//

- (NSMutableDictionary *) transportMethod;
- (void) setTransportMethod: (NSMutableDictionary *) theTransportMethod;

//
// private methods
//
- (void) _loadPersonalProfilesInPopUpButton;

@end

