/*
**  SendingView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "SendingView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation SendingView

- (id) initWithParent: (id) theParent
{
  self = [super init];
  
  parent = theParent;

  return self;
}

- (void) layoutView
{
  NSButton *addTransportMethod, *editTransportMethod, *removeTransportMethod, *addHeader, *removeHeader;
  LabelWidget *headerKeyLabel, *headerValueLabel;
  NSScrollView *scrollView;
  NSBox *box;
 
  // We first create our box
  box = [[NSBox alloc] initWithFrame: NSMakeRect(10,200,425,150)];
  [box setTitlePosition:NSAtTop];
  [box setTitle: _(@"Delivery methods")];
  [box setBorderType:NSGrooveBorder];
  
  transportMethodColumn = [[NSTableColumn alloc] initWithIdentifier: (id) SendingViewTransportMethodColumnIdentifier];
  [transportMethodColumn setEditable: NO];
  [[transportMethodColumn headerCell] setStringValue: _(@"Method")];
  [transportMethodColumn setMinWidth: 150];

  transportValueColumn = [[NSTableColumn alloc] initWithIdentifier: (id) SendingViewTransportValueColumnIdentifier];
  [transportValueColumn setEditable: NO];
  [[transportValueColumn headerCell] setStringValue: _(@"Value")];
  [transportValueColumn setMinWidth: 265];

  transportTableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,45,400,70)];
  [transportTableView setDrawsGrid: NO];
  [transportTableView setAllowsColumnSelection: NO];
  [transportTableView setAllowsColumnReordering: NO];
  [transportTableView setAllowsEmptySelection: NO];
  [transportTableView setAllowsMultipleSelection: NO];
  [transportTableView addTableColumn: transportMethodColumn];
  [transportTableView addTableColumn: transportValueColumn];
  [transportTableView setDataSource: parent]; 
  [transportTableView setDelegate: parent];
  [transportTableView setTarget: parent];
  [transportTableView setDoubleAction: @selector(editTransportMethod:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,45,400,70)];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView: transportTableView];
  [[box contentView] addSubview: scrollView];
  RELEASE(scrollView);
  

  // Our button add/edit/remove for the transport method
  addTransportMethod = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,100, ButtonHeight)];
  [addTransportMethod setStringValue: _(@"Add")];
  [addTransportMethod setTarget: parent];
  [addTransportMethod setAction: @selector(addTransportMethod:)];
  [[box contentView] addSubview: addTransportMethod];
  RELEASE(addTransportMethod);
  
  editTransportMethod = [[NSButton alloc] initWithFrame: NSMakeRect(110,5,100, ButtonHeight)];
  [editTransportMethod setStringValue: _(@"Edit")];
  [editTransportMethod setTarget: parent];
  [editTransportMethod setAction: @selector(editTransportMethod:)];
  [[box contentView] addSubview: editTransportMethod];
  RELEASE(editTransportMethod);
  
  removeTransportMethod = [[NSButton alloc] initWithFrame: NSMakeRect(215,5,100, ButtonHeight)];
  [removeTransportMethod setStringValue: _(@"Remove")];
  [removeTransportMethod setTarget: parent];
  [removeTransportMethod setAction: @selector(removeTransportMethod:)];
  [[box contentView] addSubview: removeTransportMethod];
  RELEASE(removeTransportMethod);

  [self addSubview: box];
  RELEASE(box);

  // We create the view for our additional headers
  box = [[NSBox alloc] initWithFrame: NSMakeRect(10,10,425,180)];
  [box setTitlePosition:NSAtTop];
  [box setTitle: _(@"Additional Outgoing Headers")];
  [box setBorderType:NSGrooveBorder];

  headerKeyColumn = [[NSTableColumn alloc] initWithIdentifier: (id) SendingViewHeaderKeyColumnIdentifier];
  [headerKeyColumn setEditable: YES];
  [[headerKeyColumn headerCell] setStringValue: _(@"Key")];
  [headerKeyColumn setMinWidth: 150];

  headerValueColumn = [[NSTableColumn alloc] initWithIdentifier: (id) SendingViewHeaderValueColumnIdentifier];
  [headerValueColumn setEditable: YES];
  [[headerValueColumn headerCell] setStringValue: _(@"Value")];
  [headerValueColumn setMinWidth: 265];

  headerTableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,70,400,75)];
  [headerTableView setDrawsGrid: NO];
  [headerTableView setAllowsColumnSelection: NO];
  [headerTableView setAllowsColumnReordering: NO];
  [headerTableView setAllowsEmptySelection: NO];
  [headerTableView setAllowsMultipleSelection: NO];
  [headerTableView addTableColumn: headerKeyColumn];
  [headerTableView addTableColumn: headerValueColumn];
  [headerTableView setDataSource: parent]; 
  [headerTableView setDelegate: parent];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,70,400,75)];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView: headerTableView];
  [[box contentView] addSubview: scrollView];
  RELEASE(scrollView);

  headerKeyLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,40,60,TextFieldHeight)
			       label: _(@"Key:")];
  [[box contentView] addSubview: headerKeyLabel];

  headerKeyField = [[NSTextField alloc] initWithFrame: NSMakeRect(65,40,95,TextFieldHeight)];
  [headerKeyField setEditable:YES];
  [headerKeyField setSelectable:YES];
  [[box contentView] addSubview: headerKeyField];

  headerValueLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(175,40,35,TextFieldHeight)
			    label: _(@"Value:")];
  [[box contentView] addSubview: headerValueLabel];
  
  headerValueField = [[NSTextField alloc] initWithFrame: NSMakeRect(220,40,185,TextFieldHeight)];
  [headerValueField setEditable:YES];
  [headerValueField setSelectable:YES];
  [[box contentView] addSubview: headerValueField];

  addHeader = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,100, ButtonHeight)];
  [addHeader setStringValue: _(@"Add")];
  [addHeader setTarget: parent];
  [addHeader setAction: @selector(addHeader:)];
  [[box contentView] addSubview: addHeader];
  RELEASE(addHeader);

  removeHeader = [[NSButton alloc] initWithFrame: NSMakeRect(110,5,100, ButtonHeight)];
  [removeHeader setStringValue: _(@"Remove")];
  [removeHeader setTarget: parent];
  [removeHeader setAction: @selector(removeHeader:)];
  [[box contentView] addSubview: removeHeader];
  RELEASE(removeHeader);

  [self addSubview: box];
  RELEASE(box);
}

- (void) dealloc
{
  //NSLog(@"SendingView: -dealloc");

  RELEASE(transportTableView);
  RELEASE(transportMethodColumn);
  RELEASE(transportValueColumn);

  RELEASE(headerTableView);
  RELEASE(headerKeyColumn);
  RELEASE(headerValueColumn);

  [super dealloc];
}


//
// access methods
//


- (NSTableView *) transportTableView
{
  return transportTableView;
}

- (NSTableColumn *) transportMethodColumn
{
  return transportMethodColumn;
}

- (NSTableColumn *) transportValueColumn
{
  return transportValueColumn;
}

- (NSTableView *) headerTableView
{
  return headerTableView;
}

- (NSTableColumn *) headerKeyColumn
{
  return headerKeyColumn;
}

- (NSTableColumn *) headerValueColumn
{
  return headerValueColumn;
}

- (NSTextField *) headerKeyField
{
  return headerKeyField;
}

- (NSTextField *) headerValueField
{
  return headerValueField;
}

@end
