/*
**  ReceivingWindowController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class IMAPView;
@class POP3View;

@interface ReceivingWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSTabView *tabView;
  IBOutlet NSTabViewItem *tabViewItem1;
  IBOutlet NSTabViewItem *tabViewItem2;

  IBOutlet IMAPView *imapView;
  IBOutlet POP3View *pop3View;

  IBOutlet NSTextField *serverNameField;
  IBOutlet NSTextField *serverPortField;
  IBOutlet NSTextField *usernameField;
  IBOutlet NSSecureTextField *passwordSecureField;

  IBOutlet NSPopUpButton *popup;
  IBOutlet NSButton *rememberPassword;

  // Other ivar
  NSString *serverName;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

- (void) initializeFromDefaults;


//
// action methods
// 

- (IBAction) okClicked: (id) sender;
- (IBAction) cancelClicked: (id) sender;
- (IBAction) setType: (id) sender;

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidLoad;

//
// access/mutation methods
//

- (NSString *) serverName;
- (void) setServerName: (NSString *) theName;

@end

