/*
**  NewPersonalProfilePanelController.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "NewPersonalProfilePanelController.h"

#import "GNUMailConstants.h"

#ifndef MACOSX
#import "NewPersonalProfilePanel.h"
#endif

@implementation NewPersonalProfilePanelController

- (id) initWithWindowNibName: (NSString *) windowNibName
{
#ifdef MACOSX
  
  self = [super initWithWindowNibName: windowNibName];
 
#else
  NewPersonalProfilePanel *newPersonalProfilePanel;

  newPersonalProfilePanel =
    [[NewPersonalProfilePanel alloc] initWithContentRect: NSMakeRect(200,200,300,105)
				     styleMask: (NSTitledWindowMask |
						 NSMiniaturizableWindowMask)
				     backing: NSBackingStoreBuffered
				     defer: YES];
  
  self = [super initWithWindow: newPersonalProfilePanel];
  
  [newPersonalProfilePanel layoutPanel];
  [newPersonalProfilePanel setDelegate: self];
  
  // We link our outlets
  personalProfileNameField = [newPersonalProfilePanel personalProfileNameField];
  
  RELEASE(newPersonalProfilePanel);
#endif

  [[self window] setTitle: _(@"New Personal Profile")];

  return self;
}


- (void) dealloc
{
  NSLog(@"NewPersonalProfilePanelController: -dealloc");
  TEST_RELEASE(name);

  [super dealloc];
}


//
// action methods
//

- (IBAction) okClicked: (id) sender
{
  [self setName: [personalProfileNameField stringValue]];
  
  [NSApp stopModal];
  [self close];
}


- (IBAction) cancelClicked: (id) sender
{
  [NSApp abortModal];
  [self close];
}

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification
{
  // Do nothing...
}

- (void) windowDidLoad
{
  name = nil;
}

//
// access/mutation methods
//

- (NSString *) name
{
  return name;
}

- (void) setName: (NSString *) theName
{
  if (theName)
    {
      RETAIN(theName);
      RELEASE(name);
      name = theName;
      
      [personalProfileNameField setStringValue: name];
    }
  else
    {
      RELEASE(name);
      name = nil;

      [personalProfileNameField setStringValue: @""];
    }
}

@end
