/*
**  MIMEView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "MIMEView.h"

#import "GNUMailConstants.h"


@implementation MIMEView

//
//
//
- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;
  
  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(mimeTypesColumn);
  RELEASE(fileExtensionsColumn);
  RELEASE(tableView);
  
  [super dealloc];
}


//
//
//
- (void) layoutView
{
  mimeTypesColumn = [[NSTableColumn alloc] initWithIdentifier: MimeTypeColumnIdentifier];
  [mimeTypesColumn setEditable: NO];
  [[mimeTypesColumn headerCell] setStringValue: _(@"Mime-Type")];
  [mimeTypesColumn setMinWidth: 215];

  fileExtensionsColumn = [[NSTableColumn alloc] initWithIdentifier: FileExtensionsColumnIdentifier];
  [fileExtensionsColumn setEditable: NO];
  [[fileExtensionsColumn headerCell] setStringValue: _(@"File extension(s)")];
  [fileExtensionsColumn setMinWidth: 215];
  
  tableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,40,430,300)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: mimeTypesColumn];
  [tableView addTableColumn: fileExtensionsColumn];
  [tableView setDataSource: parent];
  [tableView setDelegate: parent];
  [tableView setTarget: parent];
  [tableView setDoubleAction: @selector(edit:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,40,430,300)];
  AUTORELEASE(scrollView);
  [scrollView setHasHorizontalScroller:NO];
  [scrollView setHasVerticalScroller:YES];
  [scrollView setDocumentView:tableView];
  [self addSubview:scrollView];
  
  add = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,75,ButtonHeight)];
  AUTORELEASE(add);
  [add setTitle: _(@"Add...")];
  [add setTarget: parent];
  [add setAction: @selector(add:)];
  [self addSubview: add];
  
  delete = [[NSButton alloc] initWithFrame: NSMakeRect(85,5,75,ButtonHeight)];
  AUTORELEASE(delete);
  [delete setTitle: _(@"Delete")];
  [delete setTarget: parent];
  [delete setAction: @selector(delete:)];
  [self addSubview: delete];
  
  edit = [[NSButton alloc] initWithFrame: NSMakeRect(165,5,75,ButtonHeight)];
  AUTORELEASE(edit);
  [edit setTitle: _(@"Edit...")];
  [edit setTarget: parent];
  [edit setAction: @selector(edit:)];
  [self addSubview: edit];

  importFromMailcap = [[NSButton alloc] initWithFrame: NSMakeRect(310,5,125,ButtonHeight)];
  AUTORELEASE(importFromMailcap);
  [importFromMailcap setTitle: _(@"Import from mailcap")];
  [importFromMailcap setTarget: parent];
  [importFromMailcap setAction: @selector(importFromMailcap:)];
  [self addSubview: importFromMailcap];
}


//
// access methods
//
- (NSTableView *) tableView
{
  return tableView;
}

- (NSTableColumn *) mimeTypesColumn
{
  return mimeTypesColumn;
}

- (NSTableColumn *) fileExtensionsColumn
{
  return fileExtensionsColumn;
}

- (NSButton *) add
{
  return add;
}

- (NSButton *) delete
{
  return delete;
}

- (NSButton *) edit
{
  return edit;
}

- (NSButton *) importFromMailcap
{
  return importFromMailcap;
}

- (NSScrollView *) scrollView
{
  return scrollView;
}

@end

