/*
**  FilterMessageWindow.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "FilterMessageWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation FilterMessageWindow

- (void) dealloc
{
  //NSLog(@"FilterMessageWindow: -dealloc");
  RELEASE(label);
  RELEASE(textView);
  RELEASE(scrollView);
  
  [super dealloc];
}

- (void) layoutWindow
{
  NSButton *cancelButton, *okButton;

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,225,490,TextFieldHeight)
		       label: _(@"Text to include before original message:")];
  [[self contentView] addSubview: label];
  RETAIN(label);

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,40,490,180)];
  textView = [[NSTextView alloc] initWithFrame: [[scrollView contentView] frame]];
  //[textView setTextContainerInset: NSMakeSize(5,5)];
  [textView setBackgroundColor: [NSColor whiteColor]];
  [textView setRichText: NO];
  [textView setUsesFontPanel: NO];
  [textView setHorizontallyResizable: NO];
  [textView setVerticallyResizable: YES];
  [textView setMinSize: NSMakeSize (0, 0)];
  [textView setMaxSize: NSMakeSize (1E7, 1E7)];
  [textView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
  [[textView textContainer] setContainerSize: NSMakeSize([[scrollView contentView] frame].size.width, 
  							 1E7)];
  [[textView textContainer] setWidthTracksTextView: YES];
  [textView setEditable: YES];

  [scrollView setDocumentView: textView];
  [scrollView setHasHorizontalScroller: YES];
  [scrollView setHasVerticalScroller: NO];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setAutoresizingMask: (NSViewWidthSizable|NSViewHeightSizable)];
  [[self contentView] addSubview: scrollView];

  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(300,5,75,ButtonHeight)];
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController]];
  [cancelButton setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview: cancelButton];
  RELEASE(cancelButton);

  okButton = [[NSButton alloc] initWithFrame: NSMakeRect(385,5,75,ButtonHeight)];
  [okButton setTitle: _(@"OK")];
  [okButton setTarget: [self windowController]];
  [okButton setAction: @selector(okClicked:)];
  [[self contentView] addSubview: okButton];
  RELEASE(okButton);
  
}


//
// access/mutation methods
//

- (NSTextField *) label
{
  return label;
}

- (NSTextView *) textView
{
  return textView;
}


@end
