/*
**  Address.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Jonathan B. Leffert <jonathan@leffert.net>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>

@interface Address: NSObject <NSCoding>
{
  NSString *name;
  NSString *emailAddress;

  NSString *lowercaseName;
}

- (id) init;
- (void) dealloc;

- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

- (NSComparisonResult) compare: (Address *) theOtherAddress;

- (BOOL) matchesFilterString: (NSString *) filterString
		orComponents: (NSArray *) filterStringComponents;

- (NSString *) description;
- (NSString *) formattedAddress;

//
// class methods
//

+ (id) address;

//
// access/mutation methods
//

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (NSString *) emailAddress;
- (void) setEmailAddress: (NSString *) theAddress;

- (NSString *) lowercaseName;
- (void) setLowercaseName: (NSString *) theName;

- (int) compareAccordingToName: (Address *) anAddress;

@end
