#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# merge_psfax/Adapter.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.reports.adapters.filters.MailMerge._merge import MergeBase
import string, sys, os


class TransformAdapter(MergeBase.TransformAdapter):

  NAME = "Postscript/HylaFax"


  # What "command" separates new records?
  NEWRECORD = ""
  NEWLINE = " "

  # The regex description of the beginning and end of the repeatable sections
  REGEX = r"\A()"                   \
        + r"(.*)" \
        + r"()\Z"

  # Comments...
  COMMENTABLE = 0        # Does this output format support comments?

  MIMETYPE = 'application/postscript'  # ????

  # Escape special characters
  def escape(self, s):
    if not len(s): return s
    part = s
    for char, replace in (('\\','\\\\'), ('(',r'\('), (')','\)')):
      part = string.replace(part,char,replace)
    return part


  def merge(self, data, template, output):
    (self._tmpouthandle, self._tmpoutfile) = self.createTempFile("ps")
    MergeBase.TransformAdapter.merge(self, data, template, self._tmpouthandle)



  # XML handling stuff
  def startElement(self, name, attrs):
    if name == "record":
      self.values = {}
      if self.newPage:
        self.output.write(self.NEWRECORD)
      self.newPage = 1

    if attrs.has_key('fax'):
       self.__grabfaxnum = 1
    else:
       self.__grabfaxnum = 0
    self._attrs = attrs
    self._text = ""

  def endElement(self, name):
    if self.__grabfaxnum:
      self.__faxnum = self._text
    if name == "field":
      self.values[string.lower(self._attrs['name'])] = string.replace(
            string.strip(self._text.encode('utf-8')),'\n',self.NEWLINE)
    elif name == "record":
      self.printComment (self.output,
        "GNUe MailMerge [%s]:  Record #%d" % (self.NAME, self.recordCount))

      self.output.write(self.fieldre.sub(self.getFieldValue, self.repeating))
      self.sendFax(self.__faxnum)

      self.recordCount = self.recordCount + 1


  def sendFax(self, faxnum):
    fax_to = string.replace(string.replace(string.replace(faxnum, "`",""),';',''),'\n','')
    if not fax_to:
      print "Whoa! This record didn't have a fax number... ignoring!"
      return

    self._tmpouthandle.close()
    try:
      os.environ['GNUE_DEBUG_FAX']
      os.system('echo ' + gConfig('HylafaxCommand') % (fax_to) +" "+ self._tmpoutfile)
    except:
      os.system(gConfig('HylafaxCommand') % (fax_to) +" "+ self._tmpoutfile)
    ##self._tmpoutfile += '.ps'
    self._tmpouthandle = open(self._tmpoutfile,"w")
    self.output = self._tmpouthandle

