#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/wizards/AddEntry.py
#
# DESCRIPTION:
# Implements a basic form template
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string


class AddEntryWizard(FormPrePositioningTemplate):



  ###############
  #
  # Initialize any runtime variables
  #
  def StartWithPositioning(self, root, current,
           x=0, y=0, width=10, height=1):
    self.form = root
    self.current = current
    self.x = x
    self.y = y
    self.width = width
    self.height = height

    if not self.current['block']:
      raise InsufficientInformation, _("There are no blocks in this form.")


  ###############
  #
  # We have all the data, so generate our widget.
  #
  def Finalize(self):

    page = self.current['page']
    block = self.current['block']

    field = self.AddElement('field',block,
                           {'name': self.GetUniqueName('UnboundField1',block)})

    attrs = {'name': self.GetUniqueName('Entry1',page),
             'field': field.name,
             'block': block.name,
             'Char:x': self.x,
             'Char:y': self.y,
             'Char:width': self.width or 10,
             'Char:height': self.height or 1}


    # Create entry element
    entry = self.AddElement('entry', page, attrs)

    return 1



############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    'BaseID' : 'AddEntry',
    'BaseClass' : AddEntryWizard,
    'Name' : _('Add Entry'),
    'Description' : _('Inserts a basic unbound entry'),
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': TEMPLATE,
    'MenuLocation' : ('Insert',_('Unbound Entry'), 501.1)
}

