#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# PopupEditor.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from Utils import *
from gnue.common.apps import GDebug

#
# Our text handler
#
# When we are completed, we will call a method passed to us
# (via complete) along with a success code and the final result
# (if success = 1)
#
class PopupEditor(wxTextCtrl):
  def __init__(self, panel, complete, x, y, width, height, value):
    wxTextCtrl.__init__(self, panel, -1, pos=wxPoint(x,y),
         size=wxSize(width,height),
         style=wxTE_PROCESS_TAB|wxTE_PROCESS_ENTER|wxSIMPLE_BORDER)
    self.SetBackgroundColour(wxColour(255,239,176))
    self.__complete = complete
    self.SetValue(value)
    EVT_CHAR(self, self.OnChar)
    EVT_KILL_FOCUS(self, self.OnFocusOut)


  def done(self, success):
    if self.__complete:

      self.OnFocusOut = self._dummy

      if success:
        self.__complete(1, self.GetValue())
      else:
        self.__complete(0)


  def OnChar(self, event):
    if event.GetKeyCode() in (WXK_RETURN, WXK_TAB):
      self.done(1)

    elif event.GetKeyCode() == WXK_ESCAPE:
      self.done(0)
    else:
      event.Skip()


  def OnFocusOut(self, event):
    self.done(1)


  def _dummy(self, event):
    event.Skip()


  def Destroy(self, *args, **parms):
    self.__complete = None
    wxTextCtrl.Destroy(self, *args, **parms)

