#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# LayoutEditor.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
from gnue.designer.base.ToolBar import BaseToolBar


ToolbarMapping = 'LayoutEditor:Select,tb_select;' \
               + 'LayoutEditor:FocusOrder,tb_reorder,pulldown;' \
               + ';' \
               + 'Wizard:AddBlock,wizard_block;' \
               + 'Wizard:AddPage,wizard_page;' \
               + ';' \
               + 'Wizard:AddLabel,wizard_label;' \
               + 'Wizard:AddEntry,wizard_entrytext;'   \
               + 'Wizard:AddDropDown,wizard_entrydrop;' \
               + 'Wizard:AddCheckbox,wizard_entrycheck;' \
               + 'Wizard:AddButton,wizard_button;' \
               + 'Wizard:AddBox,wizard_box;' \

ToolbarMapping2 = 'LayoutEditor:ZoomIn,tb_zoom_in;' \
                + 'LayoutEditor:ZoomOut,tb_zoom_out;;' \
                + 'Forms:AutoResizePage,tb_resize;' \


class LayoutEditorTools(BaseToolBar):

  def init(self):
    self.registerEventListeners( {'BeginWizard' : self.onBeginWizard,
                                  'EndWizard' : self.onEndWizard,
                                  'LayoutEditor:Select': self.onSelect,
                                  'LayoutEditor:FocusOrder':self.onFocusOrder,
                                  'Cancel:LayoutEditor:Select': self.onEndSelect,
                                  'Cancel:LayoutEditor:FocusOrder':self.onEndFocusOrder })

    self.addToolbarMapping(ToolbarMapping)
    self.AddSeparator()
    self.addToolbarMapping(ToolbarMapping2)
    self.AddSeparator()
    self.AddControl(wxStaticText(self,-1,_("Block: ")))
    self.blockCombo = wxComboBox(self, -1)
    w, h = self.blockCombo.GetSizeTuple()
    self.blockCombo.SetSize((int(w*1.4), h))

    self.AddControl(self.blockCombo)

    self.onSelect(None)

  def onBeginWizard(self, event):
    try:
      self.ToggleTool(self.mapping['Wizard:%s'  % event.template['BaseID']],1)
    except KeyError:
      pass


  def onEndWizard(self, event):
    try:
      self.ToggleTool(self.mapping['Wizard:%s'  % event.template['BaseID']],0)
    except KeyError:
      pass


  def onSelect(self, event):
    try:
      self.ToggleTool(self.mapping['LayoutEditor:Select'],1)
    except KeyError:
      pass

  def onFocusOrder(self, event):
    try:
      self.ToggleTool(self.mapping['LayoutEditor:FocusOrder'],1)
    except KeyError:
      pass

  def onEndSelect(self, event):
    try:
      self.ToggleTool(self.mapping['LayoutEditor:Select'],0)
    except KeyError:
      pass

  def onEndFocusOrder(self, event):
    try:
      self.ToggleTool(self.mapping['LayoutEditor:FocusOrder'],0)
    except KeyError:
      pass

