#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# Icons.py
#
# DESCRIPTION:
#
# NOTES:
#

import os, sys
from wxPython.wx import *
from wxPython import __version__
from gnue.common.apps import GConfig

# Nasty hack to get around wxPython bug (still in 2.3.1)
class myImageList(wxImageList):
  def __del__(self):
    pass

treeIconMap = {}
treeIconList = myImageList(18,18,false)

iconlocation = os.path.join(GConfig.getInstalledBase('designer_images','common_images'),'designer')

if sys.platform != 'win32':
  icontype = wxBITMAP_TYPE_XPM
  iconextension = 'xpm'
else:
  icontype = wxBITMAP_TYPE_ICO
  iconextension = 'ico'

if __version__ < '2.3.0': # TODO: wxPython 2.2.x seems to segfault with icons
  iconextension = ''      #       this is a hack to make it not find icons
                          #       and thus not segfault.  We should never
                          #       build a win version w/ that old a wxPython

for f in ('block','datasource','entry','import','pagewidget',
          'page','trigger','properties'):
  if os.path.isfile('%s/destree_%s.%s' % (iconlocation, f,iconextension)):
    treeIconMap[f] = treeIconList.AddIcon(
        wxIcon('%s/destree_%s.%s' % (iconlocation, f,iconextension),
             icontype))
  else:
    treeIconMap[f] = treeIconList.AddIcon(wxNullIcon)
