#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# popy/DBdriver.py
#
# DESCRIPTION:
# Postgresql implementation of dbdriver using Python DB-SIG v2
# specification.
#
# NOTES:
#

from gnue.common import GDebug, GDataObjects

from gnue.common.dbdrivers._pgsql.DBdriver \
   import PGSQL_RecordSet, PGSQL_ResultSet, PGSQL_DataObject, \
          PGSQL_DataObject_SQL, PGSQL_DataObject_Object, \
	  PGSQL_TriggerExtensions

import PoPy

class PG_RecordSet(PGSQL_RecordSet):
  pass

class PG_ResultSet(PGSQL_ResultSet):
  def _loadNextRecord(self):
    if self._cursor:
      rs = None

      try:
        rsets = self._cursor.fetchmany()
# TODO: It seems that popy does what the other drivers don't
# TODO: and raises this error ALOT need to find out why
      except self._dataObject._DatabaseError, err:
        rsets = []
#       raise GDataObjects.ConnectionError, err
      if len(rsets):
        for rs in(rsets):
          if rs:
            i = 0
            dict = {}
            for f in (rs):
              dict[self._fieldNames[i]] = f
              i += 1
            self._cachedRecords.append (self._recordSetClass(parent=self, \
                                                             initialData=dict))
          else:
            return 0
        return 1
      else:
        return 0
    else:
      return 0

class PG_DataObject(PGSQL_DataObject):
  def __init__(self):
    PGSQL_DataObject.__init__(self, PoPy, PG_ResultSet)
    
class PG_DataObject_Object(PG_DataObject, \
      PGSQL_DataObject_Object):

  def __init__(self): 
    # Call PGSQL init first because PG_DataObject needs to overwrite 
    # some of its values
#    PGSQL_DataObject_Object.__init__(self) 
    PG_DataObject.__init__(self)

  def _buildQuery(self, conditions={}): 
    return PGSQL_DataObject_Object._buildQuery(self, conditions)


class PG_DataObject_SQL(PG_DataObject, \
      PGSQL_DataObject_SQL): 
  def __init__(self): 
    # Call PGSQL init first because PG_DataObject needs to overwrite 
    # some of its values
#    PGSQL_DataObject_SQL.__init__(self)
    PG_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return PGSQL_DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions(PGSQL_TriggerExtensions):
  pass


######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': PG_DataObject_Object,
  'sql':    PG_DataObject_SQL
}
