#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# odbc/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via the mxODBC Driver
#
# NOTES:
# Requires mxODBC (http://www.lemburg.com/files/python/mxODBC.html)
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     service=   This is the ODBC DSN= string to use.
#
#

#### THIS IS AN UNTESTED DRIVER ####
####      Any volunteers?       ####


import sys, string
from gnue.common import GDebug, GDataObjects, GConnections, dyn_import
from gnue.common.dbdrivers._dbsig.DBdriver \
   import DBSIG_RecordSet, DBSIG_ResultSet, DBSIG_DataObject, \
          DBSIG_DataObject_SQL, DBSIG_DataObject_Object

try:
  # This isn't actually used at this point, but is imported
  # to generate an ImportError early on if not installed.
  from mx import ODBC
except ImportError, message:
  raise GConnections.AdapterNotInstalled, \
         "Driver not installed: ODBC\nGrab mxODBC from "\
         "http://www.lemburg.com/files/python/mxODBC.html\n\n[%s]" % message


class ODBC_RecordSet(DBSIG_RecordSet):
  pass


class ODBC_ResultSet(DBSIG_ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    DBSIG_ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = ODBC_RecordSet



class ODBC_DataObject(DBSIG_DataObject):
  def __init__(self):
    DBSIG_DataObject.__init__(self)
    self._resultSetClass = ODBC_ResultSet
    self._backend = None

  def connect(self, connectData={}):
    GDebug.printMesg(1,"ODBC database driver initializing")
    try:
      backend, dsn = string.split(connectData['service'],'|',1)
      self._backend = dyn_import("mx.ODBC.%s" % backend)
      self._DatabaseError = self._backend.DatabaseError
    except ValueError:
      raise GDataObjects.ConnectionError, \
          'Invalid service string for ODBC driver.\n' +\
          'Format: service="Backend|DSNString"'
    except ImportError, mesg:
      raise GConnections.AdapterNotInstalled, \
          'Unable to load the ODBC drivers for %s' % backend

    try:
      self._dataConnection = SIG2api.connect( dsn, \
                   user=connectData['_username'], \
                   password=connectData['_password'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._postConnect()


  #
  # Schema (metadata) functions
  #

  # TODO: See postgresql for an example of what these functions do.

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('table','Table',1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    return []

  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    return None

  def _postConnect(self):
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


class ODBC_DataObject_Object(ODBC_DataObject, \
      DBSIG_DataObject_Object):

  def __init__(self):
    ODBC_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG_DataObject_Object._buildQuery(self, conditions)


class ODBC_DataObject_SQL(ODBC_DataObject, \
      DBSIG_DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because ODBC_DataObject needs to overwrite
    # some of its values
    DBSIG_DataObject_SQL.__init__(self)
    ODBC_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG_DataObject_SQL._buildQuery(self, conditions)


#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions:

  def __init__(self, connection):
    self.__connection = connection





######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': ODBC_DataObject_Object,
  'sql':    ODBC_DataObject_SQL
}

