#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# GServerApp.py
#
# DESCRIPTION:
# Class that provides a basis for GNUe server applications.
#
# NOTES:
# This will eventually have features only needed by "server"
# applications, such as abstracted client RPC calls via
# CORBA, RPC-XML, SOAP, etc and daemon/forking/threading. 
#

from GBaseApp import GBaseApp
from GLogger import Logger
import sys, os

# TODO: Implement RPC abstraction layer
# TODO: Implement either multi-threading or asynchronous IO support

class GServerApp(GBaseApp):

  def __init__(self, connections=None, application=None):
    self.COMMAND_OPTIONS.append (
         [ 'foreground','Z','no-detach',0,0, None,
           'Do not send the server into the background. For a POSIX system, '
           'this option keeps the server process from forking and detaching '
           'from its controlling terminal.'],
    )
    GBaseApp.__init__(self, connections, application)



  # This can be overwritten by code necessary
  # for startup.  If overwritten, do not first
  # call the original GServerApp.run(self) as
  # this would send to background immediately.
  # Instead, call the original GServerApp.run(self)
  # after you are sure you are finished with
  # startup code and are ready to go to server
  # mode.
  def run(self):

    # Fork, if applicable/possible, and send to background
    if not self.OPTIONS["foreground"]: 
      self.daemonize()


  # Called when a request to shutdown the server is received
  def shutdown(self): 
    pass


  # Turn ourselves into a daemon/service/etc. 
  # Returns 1 if program successfully converted,
  # 0 otherwise. 
  # 
  def daemonize(self): 

    try: 
      # Fork #1
      pid = os.fork()
      if pid != 0:
        # Close main process
        sys.exit(0)

      # Open new filehandles for stdin, stdout, stderr
      sin = open('/dev/null','r')
      sout = open('/dev/null','w')
      serr = open('/dev/null','w')

    except AttributeError: 
      return 0
    except IOError: 
      return 0
    except OSError:
      return 0


    # Disassociate ourselves
    try: 
      os.chdir('/')
      os.setsid()
      os.umask(0)
    except AttributeError: 
      pass
    except OSError:
      pass


    try: 
      # Fork #2
      pid = os.fork()
      if pid != 0: 
        sys.exit(0)
    except OSError: 
      pass


    try: 
      sys.stdin.close()
      sys.stdin = sin

      sys.stdout.close()
      sys.stdout = sout

      sys.stderr.close()
      sys.stderr = serr
    except AttributeError: 
      pass

    return 1


