//  Gnomoradio - gnomoradio/conf.cc
//  Copyright (C) 2004  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "gnomoradio/conf.h"

#ifdef USE_GCONF
Glib::RefPtr<Gnome::Conf::Client> Gnomoradio::Conf::conf;
#endif

using namespace std;

void Gnomoradio::Conf::init ()
{
#ifdef USE_GCONF
	Gnome::Conf::init();
#endif
}

int Gnomoradio::Conf::get_int (const string &key)
{
	initialize();
#ifdef USE_GCONF
	return conf->get_int("/apps/gnomoradio/" + key);
#else
	return 0;
#endif
}

void Gnomoradio::Conf::set (const string &key, int value)
{
	initialize();
#ifdef USE_GCONF
	conf->set("/apps/gnomoradio/" + key, value);
#endif
}

void Gnomoradio::Conf::initialize ()
{
	static bool _init = false;
	if (_init)
		return;
	_init = true;

#ifdef USE_GCONF
	conf = Gnome::Conf::Client::get_default_client();
#endif
}
