/*  Gnometab -- a guitar tablature editor for GNOME
    Copyright (C) 2001  William L. Guelker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

void 
create_bend(GtabDoc *tab_doc, double x, double y);

void 
create_slur(GtabDoc *tab_doc, double x, double y, 
            gint slur_type, gint positions);
                        
void
create_bar(GtabDoc *tab_doc, double x, double y, gint bar_size);

void 
create_text(GtabDoc *tab_doc, double x, double y, gchar *text);

void 
create_measure(GtabDoc *tab_doc, double x, double y);

void 
create_legato(GtabDoc *tab_doc, double x, double y, gint leg_size);

void 
create_strum(GtabDoc *tab_doc, double x, double y, 
                            gboolean upstroke, gint size);
                            
void 
create_text_entry_widget(GtabDoc *tab_doc, double x, double y);

gint
num_entry_key_press(GtkWidget *num_entry, GdkEventKey *event, GtabDoc *tab_doc);

void
translate_chord(GtabDoc *tab_doc, double x, double y, xmlDocPtr new_chord_doc);

void 
create_tab_rhythm(GtabDoc *tab_doc, Tab_Rhythm rhythm, double x, double y);

void
create_doc_props(GtabDoc *tab_doc);

void
create_timesig(GtabDoc *tab_doc, double x, double y, gint beats, gint beatval);

void
create_repeat_bar(GtabDoc *tab_doc, double x, double y, gboolean close);

void
create_comment(GtabDoc *tab_doc, double x, double y, G_CONST_RETURN gchar *comment);

void
create_rest(GtabDoc *tab_doc, double x, double y, gint value, gboolean dotted);

void
count_object(GtabDoc *tab_doc, GnomeCanvasItem *staff_obj);

gint
get_rhythm_value(G_CONST_RETURN gchar *fraction);

gint
get_rest_value(G_CONST_RETURN gchar *fraction);

gint 
find_rhythm_num_segs(xmlNodePtr staff_node, double x);

double 
find_rhythm_y2(xmlNodePtr staff_node, double x, gint total, gint index);
