/**********************************
 Send various packets to the server
 (c) 1999 Jeremy Wise
 GnomeICU
************************************/

#include "common.h"
#include "applet.h"
#include "events.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "history.h"
#include "icons.h"
#include "response.h"
#include "rus_conv.h"
#include "showlist.h"
#include "tcp.h"
#include "util.h"

void awaymsg_change_show( GtkWidget *widget, CONTACT_PTR contact );

int preset_status = STATUS_OFFLINE;

void Shortcut_Update( CONTACT_PTR contact )
{
    GtkWidget *window = contact->detached_window;
    GtkWidget *gtk_pixmap;

#ifdef TRACE_FUNCTION
    g_print("Shortcut_Update\n");
#endif

    if( !GTK_IS_WIDGET( window ) )
      return;
    gtk_pixmap = gtk_object_get_data( GTK_OBJECT( window ), "pixmap" );

    /* FIXME: these icons are set to the same values several times */
    contact->icon_p = get_pixmap_for_status( contact->status );
    contact->icon_b = get_bitmap_for_status( contact->status );
    gtk_pixmap_set( GTK_PIXMAP( gtk_pixmap ), contact->icon_p, contact->icon_b );
}

void Shortcut_Update_All( void )
{
    GSList *contact;

    contact = Contacts;

    while( contact != NULL )
    {
        if( GTK_IS_WIDGET( kontakt->detached_window ) )
            Shortcut_Update( kontakt );
        contact = contact->next;
    }
}

/* Called when user goes Offline */
void User_Offline( GSList *contact )
{

#ifdef TRACE_FUNCTION
	g_print( "User_Offline\n" );
#endif


	kontakt->last_status = kontakt->status;
	kontakt->status = STATUS_OFFLINE;
	kontakt->have_tcp_connection = FALSE;
	if( kontakt->sok )
	{
		if( kontakt->gioc )
			g_io_channel_close( kontakt->gioc );
		close( kontakt->sok );
		g_source_remove( kontakt->giocw );
		kontakt->gioc = 0;
		kontakt->sok = 0;
	}

	kontakt->last_time = time( NULL );
	kontakt->have_tcp_connection = FALSE;

	if( kontakt->inlist == TRUE )
		Show_Quick_Status_lower( UPDATE_ONLINE | UPDATE_OFFLINE, NULL );
	else
		Show_Quick_Status_lower( UPDATE_NOTLIST, NULL );

	if( toggles->applet )
		applet_update( Current_Status, FALSE );

        Shortcut_Update( kontakt );
}

void User_Online(GSList *contact)
{
	gchar *notify;

#ifdef TRACE_FUNCTION
	g_print( "User_Online (%d/%s)\n", kontakt->uin, kontakt->nick );
#endif

	if( /* enable_online_events && */ kontakt->online_notify &&
                !kontakt->ignore_list ) 
	{
		notify = g_strdup_printf( _("%s is online"),
		                          kontakt->nick );
		gtk_widget_show( gnome_message_box_new( notify,
		                 GNOME_MESSAGE_BOX_INFO,
		                 GNOME_STOCK_BUTTON_OK,
		                 NULL ) );
		g_free( notify );
	}

	if( kontakt->inlist == TRUE )
		Show_Quick_Status_lower( UPDATE_ONLINE | UPDATE_OFFLINE, NULL );
	else
		Show_Quick_Status_lower( UPDATE_NOTLIST, NULL );

	if( toggles->applet )
		applet_update( Current_Status, FALSE );

        Shortcut_Update( kontakt );
}

void  Display_Search_Reply(WORD reqid, UIN_T uin, gchar *nick, gchar *first,
                           gchar *last, gchar *email, gchar auth,
                           gchar status, gchar sex, gchar age)
{
  gchar *data[8];
  gchar *dsr_uin = NULL, *dsr_age = NULL;
  gint row = 0;
  GdkBitmap *bm;
  GdkPixmap *pm;
  
#ifdef TRACE_FUNCTION
  g_print( "Display_Search_Reply\n" );
#endif
  
  /* Status */
  data[ 0 ] = "";
  switch (status) {
  case 0:
    bm = get_bitmap_for_status (STATUS_OFFLINE);
    pm = get_pixmap_for_status (STATUS_OFFLINE);
    break;
  case 1:
    bm = get_bitmap_for_status (STATUS_ONLINE);
    pm = get_pixmap_for_status (STATUS_ONLINE);
    break;
  default:
  case 2:
    bm = icon_blank_bitmap;
    pm = icon_blank_pixmap;
    break;
  }

  /* UIN */
  data[ 1 ] = dsr_uin = g_strdup_printf( "%u", uin ) ;
  
  /* Nick Name */
  data[ 2 ] = nick;
  
  /* First Name */
  data[ 3 ] = first;

  /* Last Name */
  data[ 4 ] = last;

  /* E-Mail Address */
  data[ 5 ] = email;

  /* Sex */
  if (sex) {
    if (sex == 1)
      data[ 6 ] = _("Female");
    else if (sex == 2)
      data[ 6 ]  = _("Male");
  }
  else data[ 6 ]  = "";
  
  /* Age */
  if (age)
    data[ 7 ] = dsr_age = g_strdup_printf( "%u", age );
  else
    data[ 7 ] = "";
    
  if( found_list != NULL && GTK_IS_CLIST( found_list ) ) {
    row = gtk_clist_append( GTK_CLIST( found_list ), data );
    gtk_clist_set_pixmap (GTK_CLIST (found_list), row, 0, pm, bm);
    gtk_clist_set_row_data( GTK_CLIST( found_list ), row,
                            GUINT_TO_POINTER(uin));
  } 
  
  g_free(dsr_uin);
  if (dsr_age)
    g_free(dsr_age);
  
}

ChatContact *Do_Chat( WORD sessionlen, char *data, UIN_T uin, DWORD seq, gchar *chatsession, int port )
{
	GSList *contact;

	ChatContact *ccontact = NULL;

	STORED_MESSAGE_PTR new_stored_message = NULL;

#ifdef TRACE_FUNCTION
	g_print( "Do_Chat\n" );
#endif

	contact = Contacts;

	if( uin != 0 )
	{
		/* Find user, or add it */
		contact = Add_User( uin, NULL, FALSE );

		ccontact = g_new0(ChatContact,1);

		ccontact->contact = kontakt;
		ccontact->listen_port = port;
		ccontact->mpartynew = sessionlen;

		rus_conv(RUS_WIN_KOI,kontakt->nick );

		/* FIXME: why is this status different? */
		if( Current_Status == STATUS_FREE_CHAT )
			return ccontact;

		/* Add to personal history file */
		history_add_incoming( uin, data, NULL );

		ccontact->seq = seq;

		new_stored_message = g_new0( stored_message, 1 );
		new_stored_message->type = MESSAGE_CHAT_REQ;
		new_stored_message->message = g_strdup( data );
		new_stored_message->data = ccontact;
		if (sessionlen == 0)
		     new_stored_message->chatsessionname = NULL;
		else
		     new_stored_message->chatsessionname = g_strdup(chatsession);

		kontakt->stored_messages = g_slist_append( kontakt->stored_messages, new_stored_message );

		if( toggles->applet )
			applet_update( Current_Status, FALSE );
		Show_Quick_Status();

		gnomeicu_event( EV_CHATREQ,uin );
	}

	return ccontact;
}

GSList *Do_File( char *data, UIN_T uin, DWORD seq, gchar *file_name, int file_size )
{
	GSList *contact;

	STORED_MESSAGE_PTR new_stored_message = NULL;

	XferInfo *xferinfo;

#ifdef TRACE_FUNCTION
	g_print( "Do_File\n" );
#endif

	contact = Contacts;

	if( uin != 0 )
	{
		contact = Find_User( uin );
		/* If the user is not in list, add it */
		if( contact == NULL )
			contact = Add_User( uin, NULL, FALSE );

		/* Add to personal history file */
		history_add_incoming( uin, data, NULL );

		xferinfo = g_malloc0(sizeof(XferInfo));

		xferinfo->seq = seq;
		xferinfo->total_bytes = file_size;
		xferinfo->remote_contact = kontakt;

		xferinfo->direction = XFER_DIRECTION_RECEIVING;
		xferinfo->status = XFER_STATUS_PENDING;

		xferinfo->filename = file_name;
		xferinfo->total_bytes = file_size;

		pending_xfers = g_slist_append(pending_xfers, xferinfo);


		if (!toggles->auto_accept_xfers) {
			new_stored_message = g_new0( stored_message, 1 );
			new_stored_message->type = MESSAGE_FILE_REQ;
			new_stored_message->data = xferinfo;
			new_stored_message->message = g_strdup( data );
			kontakt->stored_messages = g_slist_append( kontakt->stored_messages, new_stored_message );
		} else {
			TCPAcceptFile(xferinfo);
		}

		if( toggles->applet )
			applet_update( Current_Status, FALSE );
		Show_Quick_Status();

		gnomeicu_event( EV_FILEREQ,uin );
	}

	return contact;
}

void msg_received (UIN_T uin, gchar *msg, time_t msg_time)
{
  
  GSList *contact = NULL;
  STORED_MESSAGE_PTR new_stored_message;

#ifdef TRACE_FUNCTION
  g_print( "msg_received\n" );
#endif

  contact = Find_User( uin );
	
  if( contact == NULL )
  {
    if( toggles->no_new_users )
      return;
    contact = Add_User( uin, NULL, FALSE );
    kontakt->confirmed = FALSE;
  }
  else
  {
    if( kontakt->ignore_list )
      return;
  }

  rus_conv(RUS_WIN_KOI,msg);
        
  if( uin != 0 )
    {

/*      if (kontakt->read_next && GTK_IS_WIDGET (kontakt->read_next) &&
          GTK_WIDGET_VISIBLE (kontakt->read_next) &&
          g_slist_length (kontakt->stored_messages) == 0)
        gtk_widget_set_sensitive (kontakt->read_next, TRUE);
*/
      kontakt->need_update = TRUE;

      gnomeicu_event( EV_MSGRECV, uin );

      history_add_incoming( uin, msg, &msg_time );

      new_stored_message = g_new0( stored_message, 1 );
      new_stored_message->type = MESSAGE_TEXT;
      new_stored_message->time = msg_time;
      new_stored_message->message = g_strdup( msg );

      kontakt->stored_messages = g_slist_append( kontakt->stored_messages, new_stored_message );

	if (kontakt->msg_dlg_xml != NULL &&
	    GTK_WIDGET_VISIBLE (glade_xml_get_widget (kontakt->msg_dlg_xml, "message_dialog")) &&
	    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glade_xml_get_widget (kontakt->msg_dlg_xml, "chat_toggle"))))
		show_contact_message (contact);

	else if (toggles->auto_popup)
		show_contact_message (contact);
	else if (kontakt->msg_dlg_xml != NULL)
		gtk_widget_set_sensitive (glade_xml_get_widget (kontakt->msg_dlg_xml, "readnext_button"), TRUE);

	applet_update (Current_Status, FALSE);
	Show_Quick_Status ();

/*      if( kontakt->msg_dlg_xml == NULL ||
          !GTK_WIDGET_VISIBLE (glade_xml_get_widget (kontakt->msg_dlg_xml, "message_dialog")))
        {


          if( toggles->auto_popup ) {
            if( (!(GTK_IS_WIDGET(kontakt->read_next))) )
              show_contact_message( contact );
          }

          applet_update( Current_Status, FALSE );
          Show_Quick_Status();
        }
      
      else
        {
          head_color.pixel = 0;
          head_color.red = 65535;
          head_color.green = 0;
          head_color.blue = 0;
          header = g_strdup_printf( "%s:  ", kontakt->nick );
          text = gtk_object_get_data( GTK_OBJECT( kontakt->message_chat ), "text" );
          gtk_text_insert( GTK_TEXT( text ), NULL, &head_color, NULL, header, -1 );
          g_free( header );
          header = g_strdup( msg );
          while( *(header+strlen(header)-1) == '\n' )
            *(header+strlen(header)-1) = 0x00;
          gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, header, -1 );
          gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, "\n", 1 );
          g_free( header );
        }
*/
    }

}

void url_received (UIN_T uin, const gchar *url, const gchar *desc, time_t msg_time)
{

  GSList *contact = NULL;
  struct tm *msg_tm;
  GdkColor head_color;
  GtkWidget *text;
  gchar *histtext;

#ifdef TRACE_FUNCTION
  g_print( "url_received\n" );
#endif

  if( uin != 0 ) {
    contact = Find_User( uin );
    if( contact == NULL )
      contact = Add_User( uin, NULL, FALSE );
    
    kontakt->need_update = TRUE;

    gnomeicu_event( EV_URLRECV,uin );

    /* Add to personal history file */

    histtext = g_strdup_printf("%s\n%s", url, desc);
    history_add_incoming( uin, histtext, &msg_time );
    g_free(histtext);

    msg_tm = localtime( &msg_time );
      
    if( kontakt->message_chat == NULL ) {
      STORED_MESSAGE_PTR new_stored_message;
        
      new_stored_message = g_new0( stored_message, 1 );
      new_stored_message->type = MESSAGE_URL;
      new_stored_message->time = msg_time;
      new_stored_message->message = g_strdup( desc );
      new_stored_message->data = g_strdup( url );

      kontakt->stored_messages = g_slist_append( kontakt->stored_messages, new_stored_message );
        
      applet_update( Current_Status, FALSE );
      Show_Quick_Status();
    } else {
      gchar *header = g_strdup_printf( "%s:  ", kontakt->nick );
      gchar *urltext = g_strdup_printf("%s\n%s\n", url, desc);
      head_color.pixel = 0;
      head_color.red = 65535;
      head_color.green = 0;
      head_color.blue = 0;
      text = gtk_object_get_data( GTK_OBJECT( kontakt->message_chat ), "text" );
      gtk_text_insert( GTK_TEXT( text ), NULL, &head_color, NULL, header, -1 );
      g_free( header );
      gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, urltext, -1 );
      g_free(urltext);
    }
  }
}

void contact_list_received (UIN_T uin, GSList *contacts, time_t msg_time)
{
  GSList *contact = NULL;
  STORED_MESSAGE_PTR new_stored_message;

#ifdef TRACE_FUNCTION
  g_print( "contact_list_received\n" );
#endif

  contact = Find_User( uin );
	
  if( contact == NULL )
  {
    if( toggles->no_new_users )
      return;
    contact = Add_User( uin, NULL, FALSE );
  }
  else
  {
    if( kontakt->ignore_list )
      return;
  }

  if( uin != 0 )
  {
    kontakt->need_update = TRUE;

    gnomeicu_event( EV_CONTLIST, uin );

    new_stored_message = g_new0( stored_message, 1 );
    new_stored_message->type = MESSAGE_CONT_LIST;
    new_stored_message->data = contacts;

    kontakt->stored_messages = g_slist_append( kontakt->stored_messages, new_stored_message );

    applet_update( Current_Status, FALSE );
    Show_Quick_Status_lower(UPDATE_ONLINE | UPDATE_OFFLINE | UPDATE_NOTLIST, NULL);
  }
}

void user_added_you (UIN_T uin, time_t msg_time)
{

  GSList *contact = NULL;
  STORED_MESSAGE_PTR new_stored_message;

#ifdef TRACE_FUNCTION
  g_print( "user_added_you\n" );
#endif

  if( uin != 0 ) {
    contact = Find_User( uin );
    if( contact == NULL )
      contact = Add_User( uin, NULL, FALSE );
    
    kontakt->need_update = TRUE;

    gnomeicu_event( EV_LISTADD,uin );

    history_add_incoming( uin, "User added you to contact list", &msg_time );
  
    new_stored_message = g_new0( stored_message, 1 );
    new_stored_message->type = MESSAGE_USER_ADD;
    new_stored_message->message = g_strdup( "User has added you" );

    kontakt->stored_messages = g_slist_append( kontakt->stored_messages,
                                               new_stored_message );

    applet_update( Current_Status, FALSE );
    Show_Quick_Status();
  }
}

void authorisation_request(UIN_T uin, gchar *nick, gchar *first, gchar *last,
                           gchar *email, gchar *msg, time_t msg_time)
{

  GSList *contact = NULL;
  struct tm *msg_tm;
  STORED_MESSAGE_PTR new_stored_message;
  gchar *tempmsg;
  
#ifdef TRACE_FUNCTION
  g_print( "authorisation_request\n" );
#endif

  if( uin != 0 ) {
    contact = Find_User( uin );
    if( contact == NULL )
      contact = Add_User( uin, nick, FALSE );
    
    kontakt->need_update = TRUE;

    gnomeicu_event( EV_AUTHREQ,uin );

    tempmsg = g_strdup_printf(_("User asked for authorisation:\n%s"), msg);
    history_add_incoming( uin, tempmsg, &msg_time );
    g_free(tempmsg);
  
    msg_tm = localtime( &msg_time );

    new_stored_message = g_new0( stored_message, 1 );
    new_stored_message->type = MESSAGE_AUTH_REQ;
    new_stored_message->message = g_strdup_printf( "User asked for auth:\n%s", msg);

    kontakt->stored_messages = g_slist_append( kontakt->stored_messages,
                                               new_stored_message );

    applet_update( Current_Status, FALSE );
    Show_Quick_Status();
  }
}

void recv_awaymsg( UIN_T uin, DWORD status, const gchar *message)
{

  gchar *away_title;
  GtkWidget *window;
  GtkWidget *dialog_vbox;
  GtkWidget *label9;
  GtkWidget *scrolledwindow2;
  GtkWidget *text2;
  GtkWidget *checkbutton2;

  GSList *contact;

#ifdef TRACE_FUNCTION
  g_print( "recv_awaymsg\n" );
#endif

  contact = Find_User( uin );
  if( contact == NULL )
    return;

  if( kontakt->show_again == FALSE )
    return;
  switch( status ) {
    case STATUS_AWAY:
      away_title = g_strdup_printf( _("User %s is Away:"), kontakt->nick );
      break;
    case STATUS_NA:
      away_title = g_strdup_printf( _("User %s is Not Available:"), kontakt->nick );
      break;
    case STATUS_DND:
      away_title = g_strdup_printf( _("User %s cannot be disturbed:"), kontakt->nick );
      break;
    case STATUS_OCCUPIED:
      away_title = g_strdup_printf( _("User %s is Occupied:"), kontakt->nick );
      break;
    case STATUS_FREE_CHAT:
      away_title = g_strdup_printf( _("User %s is Free for Chat:"), kontakt->nick );
      break;
    default:
      away_title = g_strdup( _("User is in an unknown mode:") );
    }
  window = gnome_dialog_new (_("GnomeICU: Away message"),
                             GNOME_STOCK_BUTTON_OK, NULL);
  gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);
  gtk_window_set_wmclass (GTK_WINDOW (window), "Message", "GnomeICU");
  gtk_window_set_default_size( GTK_WINDOW( window ), 200, 250 );
  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);

  dialog_vbox = GNOME_DIALOG (window)->vbox;

  label9 = gtk_label_new ( away_title );
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), label9, FALSE, FALSE, 0);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), scrolledwindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text2 = gtk_text_new (NULL, NULL);
  gtk_widget_show (text2);
  gtk_text_set_word_wrap( GTK_TEXT( text2 ), TRUE );
  gtk_text_set_editable( GTK_TEXT( text2 ), FALSE );
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);

  if( message != NULL && message[0] != '\0' )
    gtk_text_insert( GTK_TEXT( text2 ), NULL, NULL, NULL, message, -1 );

  checkbutton2 = gtk_check_button_new_with_label (_("Show Again"));
  gtk_widget_show (checkbutton2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), checkbutton2, FALSE, FALSE, 0);

  gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( checkbutton2 ),
                               kontakt->show_again );

  gtk_signal_connect (GTK_OBJECT (checkbutton2), "toggled",
                      GTK_SIGNAL_FUNC (awaymsg_change_show),
                      kontakt);

  gtk_widget_show_all( window );

}


void awaymsg_change_show( GtkWidget *widget, CONTACT_PTR contact )
{
	contact->show_again = !contact->show_again;
}
