import sys
import os
import signal
from test import start, finish, bt_dev

try:
    import btctl
    import gobject
except ImportError, e:
    print e
    sys.exit(77)

def run_obex_server():
    def request_put(a, b):
        pass

    def put(a, b, c, d, e, f):
        pass

    def progress(a, b):
        pass

    def complete(a, b):
        pass

    def error(a, b):
        print 'error'
        sys.exit(1)

    def connect(a, b):
        pass

    def disconnect(a, b):
        pass

    o = btctl.Obex()
    o.connect('request-put', request_put)
    o.connect('put', put)
    o.connect('progress', progress)
    o.connect('complete', complete)
    o.connect('error', error)
    o.connect('connect', connect)
    o.connect('disconnect', disconnect)
    m = gobject.MainLoop()
    m.run()

class obex_server:
    def __init__(self):
        pid = os.fork()
        assert pid >= 0
        if pid == 0:
            self.pid = 0
            run_obex_server()
        else:
            self.pid = pid
    def __del__(self):
        if self.pid != 0:
            os.kill(self.pid, signal.SIGKILL)
            os.waitpid(self.pid, 0)

def start_obex_server():
    if bt_dev == None:
        sys.exit(77)
    r = obex_server()
    return r

def run_test_btctl(exe):
    pid = start_obex_server()
    p   = start(exe)

    sys.exit(finish(p))
