/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*  This file is part of gnome-spell bonobo component
    copied from echo.c written by Miguel de Icaza and updated for Spell.idl needs

    Copyright (C) 1999, 2000 Helix Code, Inc.
    Authors:                 Radek Doulik <rodo@helixcode.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <gnome.h>
#include <liboaf/liboaf.h>
#include <bonobo.h>
#include "Spell.h"

static void
init_bonobo (int argc, char *argv [])
{
	CORBA_ORB orb;

        gnome_init_with_popt_table (
		"test-spell", VERSION,
		argc, argv,
		oaf_popt_options, 0, NULL); 

	orb = oaf_init (argc, argv);

	if (!bonobo_init (orb, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL))
		g_error (_("I could not initialize Bonobo"));

	bonobo_activate ();
}

static gboolean
check_obj (BonoboObjectClient *obj, gchar *id)
{
	if (!obj)
		printf ("Could not create an instance of the %s component", id);
	return obj == NULL;
}

int
main (int argc, char *argv [])
{
	BonoboObjectClient *checker_client, *dictionary_client;
	GNOME_Spell_Checker checker;
	GNOME_Spell_Dictionary en;
	GNOME_Spell_StringSeq *seq;
	CORBA_Environment   ev;
	char *checker_id, *dictionary_id;
	gint i;

	init_bonobo (argc, argv);

	   checker_id = "OAFIID:GNOME_Spell_Checker:"    API_VERSION;
	dictionary_id = "OAFIID:GNOME_Spell_Dictionary:" API_VERSION;

	   checker_client = bonobo_object_activate (checker_id, 0);
	dictionary_client = bonobo_object_activate (dictionary_id, 0);

	if (check_obj (checker_client, checker_id)
	    || check_obj (dictionary_client, dictionary_id))
		return 1;
	CORBA_exception_init (&ev);

	/*
	 * Get the CORBA Object reference from the BonoboObjectClient
	 */
	checker = bonobo_object_corba_objref (BONOBO_OBJECT (checker_client));
	en      = bonobo_object_corba_objref (BONOBO_OBJECT (dictionary_client));

	/*
	 * test dictionary
	 */
	GNOME_Spell_Dictionary_setTag (en, "language-tag", "en", &ev);

	printf ("check: %s --> %d\n",
		"helo",
		GNOME_Spell_Dictionary_checkWord (en, "helo", &ev));
	printf ("check: %s --> %d\n",
		"hello",
		GNOME_Spell_Dictionary_checkWord (en, "hello", &ev));

	printf ("get active: %d\n", GNOME_Spell_Dictionary__get_active (en, &ev));
	printf ("set active: %d\n", 0);
	GNOME_Spell_Dictionary__set_active (en, CORBA_FALSE, &ev);
	printf ("get active: %d\n", GNOME_Spell_Dictionary__get_active (en, &ev));

	printf ("check: %s --> %d\n",
		"helo",
		GNOME_Spell_Dictionary_checkWord (en, "helo", &ev));
	printf ("check: %s --> %d\n",
		"hello",
		GNOME_Spell_Dictionary_checkWord (en, "hello", &ev));

	printf ("set active: %d\n", 1);
	GNOME_Spell_Dictionary__set_active (en, CORBA_TRUE, &ev);
	printf ("check: %s --> %d\n",
		"helo",
		GNOME_Spell_Dictionary_checkWord (en, "helo", &ev));
	seq = GNOME_Spell_Dictionary_getSuggestions (en, "helo", &ev);
	printf ("suggestions for helo\n");
	for (i=0; i<seq->_length; i++)
		printf ("\t%s\n", seq->_buffer [i]);
	CORBA_free (seq);
	printf ("add helo to session\n");
	GNOME_Spell_Dictionary_addWordToSession (en, "helo", &ev);
	printf ("check: %s --> %d\n",
		"helo",
		GNOME_Spell_Dictionary_checkWord (en, "helo", &ev));
	CORBA_exception_free (&ev);

	bonobo_object_unref (BONOBO_OBJECT (checker_client));
	bonobo_object_unref (BONOBO_OBJECT (dictionary_client));
	
	return 0;
}
