/*
This file is part of Gnome Photo Printer.

    Gnome Photo Printer is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Gnome Photo Printer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Gnome Photo Printer; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GPP_FUNCTIONS_H
#define GPP_FUNCTIONS_H	1

gboolean gpp_check_page_size ();
void gpp_set_layout ();
gboolean gpp_get_settings_from_libgnomeprint ();
gboolean gpp_show_settings_from_libgnomeprint ();
gdouble gpp_calculate_size_metric_to_dpi (gdouble size);
gboolean gpp_calculate_rotate_pictures ();
gint gpp_calculate_fit_to_page (gdouble page, gdouble pic);
gint gpp_calculate_number_of_sites ();
gint gpp_calculate_pics_on_page ();
gdouble gpp_calculate_space_between_pics (gdouble page, gdouble pic);
GdkPixbuf *gpp_gdk_rotate_pixbuf_90 (GdkPixbuf * pixbuf);
gboolean gpp_check_for_image (gchar * file_name);

#endif
