/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider-button.c
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <config.h>
#include <glib/gi18n.h>
#include "gdm-info-provider.h"

static gboolean 
get_provider_matches (GdmDevice *device)
{
        return (gdm_device_test_capability (device, "button") &&
                !gdm_device_test_capability (device, "input.keyboard"));
}

static char *
get_icon_name (GdmDevice *device)
{
        return g_strdup ("gtk-media-stop");
}

static char *
get_product (GdmDevice *device)
{
        const char *type;
        const char *str;

        type = gdm_device_get_property_string (device, "button.type");
        str = _("Unknown button");
        if (type != NULL) {
                if (g_ascii_strcasecmp (type, "lid") == 0) {
                        str = _("Laptop Lid Switch");
                } else if (g_ascii_strcasecmp (type, "power") == 0) {
                        str = _("Power Button");
                } else if (g_ascii_strcasecmp (type, "sleep") == 0) {
                        str = _("Sleep Button");
                }
        }
        
        return g_strdup (str);
}

static char *
get_short_name (GdmDevice *device)
{
        return get_product (device);
}

static char *
get_long_name (GdmDevice *device)
{
        return get_short_name (device);
}

static char *
get_vendor (GdmDevice *device)
{
        return g_strdup ("");
}


#define ADD_SUM(p, key, value)                                                       \
        do {                                                                         \
                if (value != NULL) {                                                 \
                        p = g_slist_append (p, g_strdup (key));                      \
                        p = g_slist_append (p, value);                               \
                }                                                                    \
        } while (FALSE)

static GSList *
get_summary (GdmDevice *device)
{
        const char *product;
        GSList *p = NULL;

        product = gdm_device_get_property_string (device, "input.product");

        ADD_SUM (p, _("Type"), get_product (device));
        if (product != NULL)
                ADD_SUM (p, _("Description"), g_strdup (product));

        return p;
}

GdmInfoProviderIface gdm_info_provider_button =
{
        .get_provider_matches = get_provider_matches,
        .get_icon_name        = get_icon_name,
        .get_short_name       = get_short_name,
        .get_long_name        = get_long_name,
        .get_vendor           = get_vendor,
        .get_product          = get_product,
        .get_summary          = get_summary,
};

