
#ifndef __UTILS_H__
#define __UTILS_H__

void debug_print (const gchar *fmt, ...);
void warn_print (const gchar *fmt, ...);

void run_command (const gchar *command);
void run_shell_command_indir (const gchar *dir, const gchar *command);

void create_error_dialog (const gchar *msg, ...);
void create_warning_dialog (const gchar *msg, ...);
void create_question_dialog (const gchar *msg, gpointer callback);


gboolean string2int (const gchar *s, gint *i);
gboolean string2uint (const gchar *s, guint *i);
gboolean string2short (const gchar *s, gshort *sh);
gboolean string2ushort (const gchar *s, gushort *sh);
gboolean string2char (const gchar *s, gchar *c);
gboolean string2uchar (const gchar *s, guchar *c);
gboolean string2float (const gchar *s, gfloat *f);

gchar *int2string (gint i);

gchar *concat_dir_file (const gchar *dir, const gchar *file);
gchar *str_uri_basename (const gchar *uri);


void type2string (GnomeVFSFileType type, gchar *buf, guint max);
GdkPixmap *type2pixmap (GnomeVFSFileType type, gboolean big);
GdkBitmap *type2mask (GnomeVFSFileType type, gboolean big);
GdkPixmap *mime2pixmap (const gchar *mime_type, GnomeVFSFileType type, gboolean big);
GdkBitmap *mime2mask (const gchar *mime_type, GnomeVFSFileType type, gboolean big);
void name2string (gchar *filename, gchar *buf, guint max);
void perm2string (GnomeVFSFilePermissions p, gchar *buf, guint max);
void size2string (GnomeVFSFileSize size, char *buf, int max,
				  GnomeCmdSizeDispMode size_disp_mode);
void time2string (time_t t, gchar *buf, guint max, const gchar *date_format);

void mime_exec_single (GnomeCmdFile *finfo);
void mime_exec_multiple (GList *files, GnomeVFSMimeApplication *app);

//GnomeVFSFilePermissions mode2vfsperm (mode_t mode);


#endif //__UTILS_H__
