/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#ifdef HAVE_LIBGML
#include <GML.h>
#endif

#include <config.h>
#include "gnome-cmd-includes.h"

GnomeCmdMainWin *main_win;

extern int file_counter;
extern int dir_counter;

int
main (int argc, char *argv[])
{
#ifdef HAVE_LIBGML
	GML_init(9,PACKAGE,FALSE);
#endif
	
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
#endif

    gnome_init ("gnome-commander", VERSION, argc, argv);
	gdk_rgb_init ();
	gnome_vfs_init ();
#ifdef HAVE_LIBFAM	
	fam_init ();
#endif
	
	gnome_cmd_data_load ();
	gnome_cmd_style_create ();
	OWNER_init ();

	main_win = GNOME_CMD_MAIN_WIN (gnome_cmd_main_win_new ());

	gtk_widget_show (GTK_WIDGET (main_win));
	
    gtk_main ();

	gtk_object_destroy (GTK_OBJECT (main_win));

	gnome_cmd_connection_free_all ();
	gnome_cmd_data_save ();
	gnome_vfs_shutdown ();
#ifdef HAVE_LIBFAM	
	fam_shutdown ();
#endif	
	OWNER_free ();
	
	debug_print ("dir_counter: %d\n", dir_counter);
	debug_print ("file_counter: %d\n", file_counter);

#ifdef HAVE_LIBGML
	GML_end();
#endif
	
    return 0;
}

