/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 


/**
 * If you add a pixmap id here be sure to add its filename in 
 * the array in imageloader.c
 */
typedef enum {
	PIXMAP_FILE_TYPE_UNKNOWN,
	PIXMAP_FILE_TYPE_REGULAR,
	PIXMAP_FILE_TYPE_DIRECTORY,
	PIXMAP_FILE_TYPE_FIFO,
	PIXMAP_FILE_TYPE_SOCKET,
	PIXMAP_FILE_TYPE_CHAR_DEVICE,
	PIXMAP_FILE_TYPE_BLOCK_DEVICE,
	PIXMAP_FILE_TYPE_SYMLINK,
	
	PIXMAP_FILE_TYPE_UNKNOWN_BIG,
	PIXMAP_FILE_TYPE_REGULAR_BIG,
	PIXMAP_FILE_TYPE_DIRECTORY_BIG,
	PIXMAP_FILE_TYPE_FIFO_BIG,
	PIXMAP_FILE_TYPE_SOCKET_BIG,
	PIXMAP_FILE_TYPE_CHAR_DEVICE_BIG,
	PIXMAP_FILE_TYPE_BLOCK_DEVICE_BIG,
	PIXMAP_FILE_TYPE_SYMLINK_BIG,

	PIXMAP_FILE_TYPE_EXE_BIG,
	PIXMAP_CVS_FISH_SMALL,

	PIXMAP_FLIST_ARROW_UP,
	PIXMAP_FLIST_ARROW_DOWN,
	PIXMAP_FLIST_ARROW_BLANK,

	PIXMAP_SERVER_SMALL,
	PIXMAP_LOGO,
	PIXMAP_EXEC,
	PIXMAP_MKDIR,
	PIXMAP_LOCK,
	
	NUM_PIXMAPS
} Pixmap;


void IMAGE_init (GtkWidget *widget);

GdkPixmap *IMAGE_get_pixmap (Pixmap pixmap_id);
GdkBitmap *IMAGE_get_mask (Pixmap pixmap_id);
gboolean IMAGE_get_mime_pixmap_and_mask (const gchar *mime_type,
										 GdkPixmap **pixmap,
										 GdkBitmap **bitmap,
										 gboolean big);

void IMAGE_clear_mime_cache (void);
