/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_FILE_SELECTOR_FUNCS_H__
#define __GNOME_CMD_FILE_SELECTOR_FUNCS_H__


GtkType
gnome_cmd_file_selector_get_type         (void);

GtkWidget*
gnome_cmd_file_selector_new              (void);

GnomeCmdDir*
gnome_cmd_file_selector_get_directory    (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_set_directory    (GnomeCmdFileSelector *fs,
										  GnomeCmdDir *dir);

void
gnome_cmd_file_selector_reload           (GnomeCmdFileSelector *fs);

GnomeVFSURI*
gnome_cmd_file_selector_get_directory_uri (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_set_active       (GnomeCmdFileSelector *fs,
										  gboolean value);

GnomeCmdFileSelectorModeType
gnome_cmd_file_selector_get_mode         (GnomeCmdFileSelector *fs);

const gchar*
gnome_cmd_file_selector_get_mode_sting   (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_set_mode         (GnomeCmdFileSelector *fs,
										  GnomeCmdFileSelectorModeType mode);

void
gnome_cmd_file_selector_set_ftp_hostname (GnomeCmdFileSelector *fs,
										  char *hostname);

void
gnome_cmd_file_selector_set_ftp_hostport (GnomeCmdFileSelector *fs,
										  short hostport);

void
gnome_cmd_file_selector_set_ftp_username (GnomeCmdFileSelector *fs,
										  char *username);

void
gnome_cmd_file_selector_set_ftp_password (GnomeCmdFileSelector *fs,
										  char *password);

GList*
gnome_cmd_file_selector_get_selected_files (GnomeCmdFileSelector *fs);

GList*
gnome_cmd_file_selector_get_all_files (GnomeCmdFileSelector *fs);

GnomeCmdFile*
gnome_cmd_file_selector_get_selected_file (GnomeCmdFileSelector *fs);

GnomeVFSURI*
gnome_cmd_file_selector_create_uri       (GnomeCmdFileSelector *fs,
										  const gchar *path);

void
gnome_cmd_file_selector_set_connection (GnomeCmdFileSelector *fs,
										GnomeCmdConnection *con);

void
gnome_cmd_file_selector_update_connections (GnomeCmdFileSelector *fs);

GnomeCmdConnection*
gnome_cmd_file_selector_get_connection (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_select_all (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_unselect_all (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_toggle (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_toggle_and_step (GnomeCmdFileSelector *fs);

void
gnome_cmd_file_selector_focus_file (GnomeCmdFileSelector *fs, const gchar *focus_file);

void
gnome_cmd_file_selector_update_style (GnomeCmdFileSelector *fs);

gint
gnome_cmd_file_selector_get_row (GnomeCmdFileSelector *fs, gint x, gint y);

void
gnome_cmd_file_selector_select_row (GnomeCmdFileSelector *fs, gint row);

#endif //__GNOME_CMD_FILE_SELECTOR_FUNCS_H__
