/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

static GnomeDialogClass *parent_class = NULL;


struct _GnomeCmdCvsServerDialogPrivate {
	GnomeCmdCvsServer *server;

	GtkWidget *alias_entry;
	GtkWidget *string_entry;
};




static void
show_server (GnomeCmdCvsServerDialog *dialog, GnomeCmdCvsServer *server)
{
	char *alias = gnome_cmd_cvs_server_get_alias (server);
	char *string  = gnome_cmd_cvs_server_get_string (server);

	gtk_entry_set_text (GTK_ENTRY (dialog->priv->alias_entry), alias);
	gtk_entry_set_text (GTK_ENTRY (dialog->priv->string_entry), string);

	dialog->priv->server = server;
}


static gboolean
update_server (GnomeCmdCvsServerDialog *dialog)
{
	GnomeCmdCvsServer *server = dialog->priv->server;

	char *alias = gtk_entry_get_text (GTK_ENTRY (dialog->priv->alias_entry));
	char *string  = gtk_entry_get_text (GTK_ENTRY (dialog->priv->string_entry));

	gnome_cmd_cvs_server_set_alias (server, alias);
	gnome_cmd_cvs_server_set_string (server, string);
		
	return TRUE;
}


static void
on_ok_btn_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdCvsServerDialog *dialog = GNOME_CMD_CVS_SERVER_DIALOG (user_data);

	if (update_server (dialog))
		gtk_widget_hide (GTK_WIDGET (dialog));
}


static void
on_cancel_btn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GnomeCmdCvsServerDialog *dialog = GNOME_CMD_CVS_SERVER_DIALOG (user_data);
	
	gtk_widget_hide (GTK_WIDGET (dialog));
}












/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	GnomeCmdCvsServerDialog *dialog = GNOME_CMD_CVS_SERVER_DIALOG (object);

	if (!dialog->priv)
		g_warning ("GnomeCmdCvsServerDialog: dialog->priv != NULL test failed\n");
	else
		g_free (dialog->priv);

	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdCvsServerDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());

	object_class->destroy = destroy;

	widget_class->map = map;
}

static void
init (GnomeCmdCvsServerDialog *dialog)
{
	GtkWidget *dialog_vbox21;
	GtkWidget *table5;
	GtkWidget *alias_label;
	GtkWidget *string_label;
	GtkWidget *cancel_button;
	
	dialog->priv = g_new (GnomeCmdCvsServerDialogPrivate, 1);	


	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

	dialog_vbox21 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox21", dialog_vbox21);
	gtk_widget_show (dialog_vbox21);

	table5 = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (table5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "table5", table5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table5);
	gtk_box_pack_start (GTK_BOX (dialog_vbox21), table5, FALSE, FALSE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table5), 2);
	gtk_table_set_col_spacings (GTK_TABLE (table5), 2);

	
	alias_label = gtk_label_new (_("alias"));
	gtk_widget_ref (alias_label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "alias_label", alias_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alias_label);
	gtk_table_attach (GTK_TABLE (table5), alias_label, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (alias_label), 0, 0.5);

	string_label = gtk_label_new (_("cvsroot"));
	gtk_widget_ref (string_label);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "string_label", string_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (string_label);
	gtk_table_attach (GTK_TABLE (table5), string_label, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (string_label), 0, 0.5);

	dialog->priv->alias_entry = gtk_entry_new ();
	gtk_widget_ref (dialog->priv->alias_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "alias_entry", dialog->priv->alias_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->alias_entry);
	gtk_table_attach (GTK_TABLE (table5), dialog->priv->alias_entry, 1, 2, 0, 1,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	dialog->priv->string_entry = gtk_entry_new ();
	gtk_widget_ref (dialog->priv->string_entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "string_entry", dialog->priv->string_entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->string_entry);
	gtk_table_attach (GTK_TABLE (table5), dialog->priv->string_entry, 1, 2, 1, 2,
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);

	
	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_OK);
	dialog->ok_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (dialog->ok_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "ok_button", dialog->ok_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->ok_button);
	GTK_WIDGET_SET_FLAGS (dialog->ok_button, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CANCEL);
	cancel_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "cancel_button", cancel_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

	
	gtk_signal_connect (GTK_OBJECT (dialog->ok_button), "clicked",
						GTK_SIGNAL_FUNC (on_ok_btn_clicked),
						dialog);
	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
						GTK_SIGNAL_FUNC (on_cancel_btn_clicked),
						dialog);
}




/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_cvs_server_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdCvsServerDialog",
			sizeof (GnomeCmdCvsServerDialog),
			sizeof (GnomeCmdCvsServerDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


GtkWidget*
gnome_cmd_cvs_server_dialog_new (GnomeCmdCvsServer *server)
{	
	GnomeCmdCvsServerDialog *dialog;
	dialog = gtk_type_new (gnome_cmd_cvs_server_dialog_get_type ());

	show_server (dialog, server);
	
	return GTK_WIDGET (dialog);
}
