/* view.c generated by valac 0.41.91, the Vala compiler
 * generated from view.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
 * Copyright (C) 2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <stdlib.h>
#include <gee.h>


#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;
typedef struct _RoundedRectanglePrivate RoundedRectanglePrivate;
enum  {
	ROUNDED_RECTANGLE_0_PROPERTY,
	ROUNDED_RECTANGLE_ACTOR_PROPERTY,
	ROUNDED_RECTANGLE_COLOR_PROPERTY,
	ROUNDED_RECTANGLE_CANVAS_PROPERTY,
	ROUNDED_RECTANGLE_NUM_PROPERTIES
};
static GParamSpec* rounded_rectangle_properties[ROUNDED_RECTANGLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;
typedef struct _TileViewPrivate TileViewPrivate;
enum  {
	TILE_VIEW_0_PROPERTY,
	TILE_VIEW_VALUE_PROPERTY,
	TILE_VIEW_NUM_PROPERTIES
};
static GParamSpec* tile_view_properties[TILE_VIEW_NUM_PROPERTIES];
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_COLOR_PALETTE (color_palette_get_type ())
#define COLOR_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOR_PALETTE, ColorPalette))
#define COLOR_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOR_PALETTE, ColorPaletteClass))
#define IS_COLOR_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOR_PALETTE))
#define IS_COLOR_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOR_PALETTE))
#define COLOR_PALETTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOR_PALETTE, ColorPaletteClass))

typedef struct _ColorPalette ColorPalette;
typedef struct _ColorPaletteClass ColorPaletteClass;
typedef struct _ColorPalettePrivate ColorPalettePrivate;
enum  {
	COLOR_PALETTE_0_PROPERTY,
	COLOR_PALETTE_NUM_PROPERTIES
};
static GParamSpec* color_palette_properties[COLOR_PALETTE_NUM_PROPERTIES];

struct _RoundedRectangle {
	GObject parent_instance;
	RoundedRectanglePrivate * priv;
	ClutterActor* _actor;
	ClutterCanvas* _canvas;
	ClutterColor* _color;
};

struct _RoundedRectangleClass {
	GObjectClass parent_class;
	gboolean (*_draw) (RoundedRectangle* self, cairo_t* ctx, gint width, gint height);
};

struct _TileView {
	RoundedRectangle parent_instance;
	TileViewPrivate * priv;
};

struct _TileViewClass {
	RoundedRectangleClass parent_class;
};

struct _TileViewPrivate {
	guint _value;
};

struct _ColorPalette {
	GObject parent_instance;
	ColorPalettePrivate * priv;
};

struct _ColorPaletteClass {
	GObjectClass parent_class;
};

struct _ColorPalettePrivate {
	GeeHashMap* _palette;
};


static gpointer rounded_rectangle_parent_class = NULL;
static gint TileView_private_offset;
static gpointer tile_view_parent_class = NULL;
static gint ColorPalette_private_offset;
static gpointer color_palette_parent_class = NULL;
static ColorPalette* color_palette__singleton;
static ColorPalette* color_palette__singleton = NULL;

GType rounded_rectangle_get_type (void) G_GNUC_CONST;
RoundedRectangle* rounded_rectangle_new (gfloat x,
                                         gfloat y,
                                         gfloat width,
                                         gfloat height,
                                         ClutterColor* color);
RoundedRectangle* rounded_rectangle_construct (GType object_type,
                                               gfloat x,
                                               gfloat y,
                                               gfloat width,
                                               gfloat height,
                                               ClutterColor* color);
static ClutterColor* _clutter_color_dup (ClutterColor* self);
gboolean _rounded_rectangle_draw (RoundedRectangle* self,
                                  cairo_t* ctx,
                                  gint width,
                                  gint height);
static gboolean __rounded_rectangle_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                                       cairo_t* cr,
                                                       gint width,
                                                       gint height,
                                                       gpointer self);
void rounded_rectangle_resize (RoundedRectangle* self,
                               gfloat x,
                               gfloat y,
                               gfloat width,
                               gfloat height);
void rounded_rectangle_idle_resize (RoundedRectangle* self);
static gboolean rounded_rectangle_real__draw (RoundedRectangle* self,
                                       cairo_t* ctx,
                                       gint width,
                                       gint height);
ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
void rounded_rectangle_get_color (RoundedRectangle* self,
                                  ClutterColor * result);
void rounded_rectangle_set_color (RoundedRectangle* self,
                                  ClutterColor * value);
ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
static void rounded_rectangle_finalize (GObject * obj);
static void _vala_rounded_rectangle_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_rounded_rectangle_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
GType tile_view_get_type (void) G_GNUC_CONST;
TileView* tile_view_new (gfloat x,
                         gfloat y,
                         gfloat width,
                         gfloat height,
                         guint val);
TileView* tile_view_construct (GType object_type,
                               gfloat x,
                               gfloat y,
                               gfloat width,
                               gfloat height,
                               guint val);
static void _tile_view_pick_color (TileView* self,
                            ClutterColor* result);
static gboolean tile_view_real__draw (RoundedRectangle* base,
                               cairo_t* ctx,
                               gint width,
                               gint height);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
guint tile_view_get_value (TileView* self);
GType color_palette_get_type (void) G_GNUC_CONST;
ColorPalette* color_palette_get_instance (void);
void color_palette_pick_color (ColorPalette* self,
                               guint val,
                               ClutterColor* result);
void tile_view_set_value (TileView* self,
                          guint value);
static void tile_view_finalize (GObject * obj);
static void _vala_tile_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_tile_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
ColorPalette* color_palette_new (void);
ColorPalette* color_palette_construct (GType object_type);
static void color_palette_finalize (GObject * obj);


static ClutterColor*
_clutter_color_dup (ClutterColor* self)
{
	ClutterColor* dup;
	dup = g_new0 (ClutterColor, 1);
	memcpy (dup, self, sizeof (ClutterColor));
	return dup;
}


static gpointer
__clutter_color_dup0 (gpointer self)
{
	return self ? _clutter_color_dup (self) : NULL;
}


static gboolean
__rounded_rectangle_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self)
{
	gboolean result;
	result = _rounded_rectangle_draw ((RoundedRectangle*) self, cr, width, height);
	return result;
}


RoundedRectangle*
rounded_rectangle_construct (GType object_type,
                             gfloat x,
                             gfloat y,
                             gfloat width,
                             gfloat height,
                             ClutterColor* color)
{
	RoundedRectangle * self = NULL;
	ClutterColor* _tmp0_;
	ClutterCanvas* _tmp1_;
	ClutterCanvas* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterCanvas* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterCanvas* _tmp10_;
	self = (RoundedRectangle*) g_object_new (object_type, NULL);
	_tmp0_ = __clutter_color_dup0 (color);
	_g_free0 (self->_color);
	self->_color = _tmp0_;
	_tmp1_ = (ClutterCanvas*) clutter_canvas_new ();
	_g_object_unref0 (self->_canvas);
	self->_canvas = _tmp1_;
	_tmp2_ = self->_canvas;
	clutter_canvas_set_size (_tmp2_, (gint) ceilf (width), (gint) ceilf (height));
	_tmp3_ = clutter_actor_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->_actor);
	self->_actor = _tmp3_;
	_tmp4_ = self->_actor;
	clutter_actor_set_size (_tmp4_, width, height);
	_tmp5_ = self->_actor;
	_tmp6_ = self->_canvas;
	clutter_actor_set_content (_tmp5_, (ClutterContent*) _tmp6_);
	_tmp7_ = self->_actor;
	clutter_actor_set_x (_tmp7_, x);
	_tmp8_ = self->_actor;
	clutter_actor_set_y (_tmp8_, y);
	_tmp9_ = self->_actor;
	clutter_actor_set_pivot_point (_tmp9_, 0.5f, 0.5f);
	_tmp10_ = self->_canvas;
	g_signal_connect_object (_tmp10_, "draw", (GCallback) __rounded_rectangle_draw_clutter_canvas_draw, self, 0);
	return self;
}


RoundedRectangle*
rounded_rectangle_new (gfloat x,
                       gfloat y,
                       gfloat width,
                       gfloat height,
                       ClutterColor* color)
{
	return rounded_rectangle_construct (TYPE_ROUNDED_RECTANGLE, x, y, width, height, color);
}


void
rounded_rectangle_resize (RoundedRectangle* self,
                          gfloat x,
                          gfloat y,
                          gfloat width,
                          gfloat height)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_actor;
	clutter_actor_set_x (_tmp0_, x);
	_tmp1_ = self->_actor;
	clutter_actor_set_y (_tmp1_, y);
	_tmp2_ = self->_actor;
	clutter_actor_set_width (_tmp2_, width);
	_tmp3_ = self->_actor;
	clutter_actor_set_height (_tmp3_, height);
}


void
rounded_rectangle_idle_resize (RoundedRectangle* self)
{
	ClutterCanvas* _tmp0_;
	ClutterActor* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterActor* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_canvas;
	_tmp1_ = self->_actor;
	_tmp2_ = clutter_actor_get_width (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->_actor;
	_tmp5_ = clutter_actor_get_height (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!clutter_canvas_set_size (_tmp0_, (gint) ceilf (_tmp3_), (gint) ceilf (_tmp6_))) {
		ClutterCanvas* _tmp7_;
		_tmp7_ = self->_canvas;
		clutter_content_invalidate ((ClutterContent*) _tmp7_);
	}
}


static gboolean
rounded_rectangle_real__draw (RoundedRectangle* self,
                              cairo_t* ctx,
                              gint width,
                              gint height)
{
	gboolean result = FALSE;
	gdouble radius = 0.0;
	gdouble degrees = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	ClutterColor* _tmp20_;
	g_return_val_if_fail (ctx != NULL, FALSE);
	radius = height / 20.0;
	degrees = G_PI / 180.0;
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_restore (ctx);
	cairo_new_sub_path (ctx);
	_tmp0_ = radius;
	_tmp1_ = radius;
	_tmp2_ = radius;
	_tmp3_ = degrees;
	_tmp4_ = degrees;
	cairo_arc (ctx, width - _tmp0_, _tmp1_, _tmp2_, -90 * _tmp3_, 0 * _tmp4_);
	_tmp5_ = radius;
	_tmp6_ = radius;
	_tmp7_ = radius;
	_tmp8_ = degrees;
	_tmp9_ = degrees;
	cairo_arc (ctx, width - _tmp5_, height - _tmp6_, _tmp7_, 0 * _tmp8_, 90 * _tmp9_);
	_tmp10_ = radius;
	_tmp11_ = radius;
	_tmp12_ = radius;
	_tmp13_ = degrees;
	_tmp14_ = degrees;
	cairo_arc (ctx, _tmp10_, height - _tmp11_, _tmp12_, 90 * _tmp13_, 180 * _tmp14_);
	_tmp15_ = radius;
	_tmp16_ = radius;
	_tmp17_ = radius;
	_tmp18_ = degrees;
	_tmp19_ = degrees;
	cairo_arc (ctx, _tmp15_, _tmp16_, _tmp17_, 180 * _tmp18_, 270 * _tmp19_);
	cairo_close_path (ctx);
	_tmp20_ = self->_color;
	if (_tmp20_ != NULL) {
		ClutterColor* _tmp21_;
		ClutterColor _tmp22_;
		_tmp21_ = self->_color;
		_tmp22_ = *_tmp21_;
		clutter_cairo_set_source_color (ctx, &_tmp22_);
		cairo_fill (ctx);
	}
	result = FALSE;
	return result;
}


gboolean
_rounded_rectangle_draw (RoundedRectangle* self,
                         cairo_t* ctx,
                         gint width,
                         gint height)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return ROUNDED_RECTANGLE_GET_CLASS (self)->_draw (self, ctx, width, height);
}


ClutterActor*
rounded_rectangle_get_actor (RoundedRectangle* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_actor;
	result = _tmp0_;
	return result;
}


void
rounded_rectangle_get_color (RoundedRectangle* self,
                             ClutterColor * result)
{
	ClutterColor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_color;
	*result = *_tmp0_;
	return;
}


void
rounded_rectangle_set_color (RoundedRectangle* self,
                             ClutterColor * value)
{
	ClutterColor _tmp0_;
	ClutterColor* _tmp1_;
	ClutterCanvas* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	_tmp1_ = __clutter_color_dup0 (&_tmp0_);
	_g_free0 (self->_color);
	self->_color = _tmp1_;
	_tmp2_ = self->_canvas;
	clutter_content_invalidate ((ClutterContent*) _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, rounded_rectangle_properties[ROUNDED_RECTANGLE_COLOR_PROPERTY]);
}


ClutterCanvas*
rounded_rectangle_get_canvas (RoundedRectangle* self)
{
	ClutterCanvas* result;
	ClutterCanvas* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_canvas;
	result = _tmp0_;
	return result;
}


static void
rounded_rectangle_class_init (RoundedRectangleClass * klass)
{
	rounded_rectangle_parent_class = g_type_class_peek_parent (klass);
	((RoundedRectangleClass *) klass)->_draw = (gboolean (*) (RoundedRectangle *, cairo_t*, gint, gint)) rounded_rectangle_real__draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_rounded_rectangle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rounded_rectangle_set_property;
	G_OBJECT_CLASS (klass)->finalize = rounded_rectangle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_ACTOR_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_COLOR_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_COLOR_PROPERTY] = g_param_spec_boxed ("color", "color", "color", CLUTTER_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_CANVAS_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_CANVAS_PROPERTY] = g_param_spec_object ("canvas", "canvas", "canvas", clutter_canvas_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
rounded_rectangle_instance_init (RoundedRectangle * self)
{
}


static void
rounded_rectangle_finalize (GObject * obj)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	_g_object_unref0 (self->_actor);
	_g_object_unref0 (self->_canvas);
	_g_free0 (self->_color);
	G_OBJECT_CLASS (rounded_rectangle_parent_class)->finalize (obj);
}


GType
rounded_rectangle_get_type (void)
{
	static volatile gsize rounded_rectangle_type_id__volatile = 0;
	if (g_once_init_enter (&rounded_rectangle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RoundedRectangleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rounded_rectangle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RoundedRectangle), 0, (GInstanceInitFunc) rounded_rectangle_instance_init, NULL };
		GType rounded_rectangle_type_id;
		rounded_rectangle_type_id = g_type_register_static (G_TYPE_OBJECT, "RoundedRectangle", &g_define_type_info, 0);
		g_once_init_leave (&rounded_rectangle_type_id__volatile, rounded_rectangle_type_id);
	}
	return rounded_rectangle_type_id__volatile;
}


static void
_vala_rounded_rectangle_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	switch (property_id) {
		case ROUNDED_RECTANGLE_ACTOR_PROPERTY:
		g_value_set_object (value, rounded_rectangle_get_actor (self));
		break;
		case ROUNDED_RECTANGLE_COLOR_PROPERTY:
		{
			ClutterColor boxed;
			rounded_rectangle_get_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case ROUNDED_RECTANGLE_CANVAS_PROPERTY:
		g_value_set_object (value, rounded_rectangle_get_canvas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_rounded_rectangle_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	switch (property_id) {
		case ROUNDED_RECTANGLE_COLOR_PROPERTY:
		rounded_rectangle_set_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
tile_view_get_instance_private (TileView* self)
{
	return G_STRUCT_MEMBER_P (self, TileView_private_offset);
}


TileView*
tile_view_construct (GType object_type,
                     gfloat x,
                     gfloat y,
                     gfloat width,
                     gfloat height,
                     guint val)
{
	TileView * self = NULL;
	ClutterColor _tmp0_ = {0};
	ClutterColor* _tmp1_;
	self = (TileView*) rounded_rectangle_construct (object_type, x, y, width, height, NULL);
	self->priv->_value = val;
	_tile_view_pick_color (self, &_tmp0_);
	_tmp1_ = __clutter_color_dup0 (&_tmp0_);
	_g_free0 (((RoundedRectangle*) self)->_color);
	((RoundedRectangle*) self)->_color = _tmp1_;
	return self;
}


TileView*
tile_view_new (gfloat x,
               gfloat y,
               gfloat width,
               gfloat height,
               guint val)
{
	return tile_view_construct (TYPE_TILE_VIEW, x, y, width, height, val);
}


static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}


static gboolean
tile_view_real__draw (RoundedRectangle* base,
                      cairo_t* ctx,
                      gint width,
                      gint height)
{
	TileView * self;
	gboolean result = FALSE;
	PangoRectangle logical_rect = {0};
	PangoLayout* layout = NULL;
	PangoFontDescription* font_desc = NULL;
	PangoLayout* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PangoFontDescription* _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	PangoRectangle _tmp7_ = {0};
	PangoRectangle _tmp8_;
	gint _tmp9_;
	PangoRectangle _tmp10_;
	gint _tmp11_;
	self = (TileView*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	ROUNDED_RECTANGLE_CLASS (tile_view_parent_class)->_draw (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ROUNDED_RECTANGLE, RoundedRectangle), ctx, width, height);
	cairo_set_source_rgb (ctx, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp0_ = pango_cairo_create_layout (ctx);
	_g_object_unref0 (layout);
	layout = _tmp0_;
	_tmp1_ = g_strdup_printf ("Sans Bold %dpx", height / 4);
	_tmp2_ = _tmp1_;
	_tmp3_ = pango_font_description_from_string (_tmp2_);
	__vala_PangoFontDescription_free0 (font_desc);
	font_desc = _tmp3_;
	_g_free0 (_tmp2_);
	pango_layout_set_font_description (layout, font_desc);
	_tmp4_ = self->priv->_value;
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
	_tmp6_ = _tmp5_;
	pango_layout_set_text (layout, _tmp6_, -1);
	_g_free0 (_tmp6_);
	pango_layout_get_extents (layout, NULL, &_tmp7_);
	logical_rect = _tmp7_;
	_tmp8_ = logical_rect;
	_tmp9_ = _tmp8_.width;
	_tmp10_ = logical_rect;
	_tmp11_ = _tmp10_.height;
	cairo_move_to (ctx, (gdouble) ((width / 2) - ((_tmp9_ / 2) / PANGO_SCALE)), (gdouble) ((height / 2) - ((_tmp11_ / 2) / PANGO_SCALE)));
	pango_cairo_show_layout (ctx, layout);
	result = FALSE;
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (layout);
	return result;
}


static void
_tile_view_pick_color (TileView* self,
                       ClutterColor* result)
{
	ColorPalette* _tmp0_;
	ColorPalette* _tmp1_;
	guint _tmp2_;
	ClutterColor _tmp3_ = {0};
	ClutterColor _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = color_palette_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_value;
	color_palette_pick_color (_tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	*result = _tmp4_;
	return;
}


guint
tile_view_get_value (TileView* self)
{
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void
tile_view_set_value (TileView* self,
                     guint value)
{
	g_return_if_fail (self != NULL);
	if (tile_view_get_value (self) != value) {
		self->priv->_value = value;
		g_object_notify_by_pspec ((GObject *) self, tile_view_properties[TILE_VIEW_VALUE_PROPERTY]);
	}
}


static void
tile_view_class_init (TileViewClass * klass)
{
	tile_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TileView_private_offset);
	((RoundedRectangleClass *) klass)->_draw = (gboolean (*) (RoundedRectangle *, cairo_t*, gint, gint)) tile_view_real__draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_tile_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tile_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = tile_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TILE_VIEW_VALUE_PROPERTY, tile_view_properties[TILE_VIEW_VALUE_PROPERTY] = g_param_spec_uint ("value", "value", "value", 0, G_MAXUINT, (guint) 2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
tile_view_instance_init (TileView * self)
{
	self->priv = tile_view_get_instance_private (self);
	self->priv->_value = (guint) 2;
}


static void
tile_view_finalize (GObject * obj)
{
	TileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_VIEW, TileView);
	G_OBJECT_CLASS (tile_view_parent_class)->finalize (obj);
}


GType
tile_view_get_type (void)
{
	static volatile gsize tile_view_type_id__volatile = 0;
	if (g_once_init_enter (&tile_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileView), 0, (GInstanceInitFunc) tile_view_instance_init, NULL };
		GType tile_view_type_id;
		tile_view_type_id = g_type_register_static (TYPE_ROUNDED_RECTANGLE, "TileView", &g_define_type_info, 0);
		TileView_private_offset = g_type_add_instance_private (tile_view_type_id, sizeof (TileViewPrivate));
		g_once_init_leave (&tile_view_type_id__volatile, tile_view_type_id);
	}
	return tile_view_type_id__volatile;
}


static void
_vala_tile_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	TileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE_VIEW, TileView);
	switch (property_id) {
		case TILE_VIEW_VALUE_PROPERTY:
		g_value_set_uint (value, tile_view_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_tile_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	TileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE_VIEW, TileView);
	switch (property_id) {
		case TILE_VIEW_VALUE_PROPERTY:
		tile_view_set_value (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
color_palette_get_instance_private (ColorPalette* self)
{
	return G_STRUCT_MEMBER_P (self, ColorPalette_private_offset);
}


ColorPalette*
color_palette_construct (GType object_type)
{
	ColorPalette * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	ClutterColor _tmp2_ = {0};
	GeeHashMap* _tmp3_;
	ClutterColor _tmp4_ = {0};
	GeeHashMap* _tmp5_;
	ClutterColor _tmp6_ = {0};
	GeeHashMap* _tmp7_;
	ClutterColor _tmp8_ = {0};
	GeeHashMap* _tmp9_;
	ClutterColor _tmp10_ = {0};
	GeeHashMap* _tmp11_;
	ClutterColor _tmp12_ = {0};
	GeeHashMap* _tmp13_;
	ClutterColor _tmp14_ = {0};
	GeeHashMap* _tmp15_;
	ClutterColor _tmp16_ = {0};
	GeeHashMap* _tmp17_;
	ClutterColor _tmp18_ = {0};
	GeeHashMap* _tmp19_;
	ClutterColor _tmp20_ = {0};
	GeeHashMap* _tmp21_;
	ClutterColor _tmp22_ = {0};
	self = (ColorPalette*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, CLUTTER_TYPE_COLOR, (GBoxedCopyFunc) _clutter_color_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_palette);
	self->priv->_palette = _tmp0_;
	_tmp1_ = self->priv->_palette;
	clutter_color_from_string (&_tmp2_, "#fce94f");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) ((guint) 2)), &_tmp2_);
	_tmp3_ = self->priv->_palette;
	clutter_color_from_string (&_tmp4_, "#8ae234");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) ((guint) 4)), &_tmp4_);
	_tmp5_ = self->priv->_palette;
	clutter_color_from_string (&_tmp6_, "#fcaf3e");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) ((guint) 8)), &_tmp6_);
	_tmp7_ = self->priv->_palette;
	clutter_color_from_string (&_tmp8_, "#729fcf");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) ((guint) 16)), &_tmp8_);
	_tmp9_ = self->priv->_palette;
	clutter_color_from_string (&_tmp10_, "#ad7fa8");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, (gpointer) ((guintptr) ((guint) 32)), &_tmp10_);
	_tmp11_ = self->priv->_palette;
	clutter_color_from_string (&_tmp12_, "#c17d11");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) ((guint) 64)), &_tmp12_);
	_tmp13_ = self->priv->_palette;
	clutter_color_from_string (&_tmp14_, "#ef2929");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, (gpointer) ((guintptr) ((guint) 128)), &_tmp14_);
	_tmp15_ = self->priv->_palette;
	clutter_color_from_string (&_tmp16_, "#c4a000");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, (gpointer) ((guintptr) ((guint) 256)), &_tmp16_);
	_tmp17_ = self->priv->_palette;
	clutter_color_from_string (&_tmp18_, "#4e9a06");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, (gpointer) ((guintptr) ((guint) 512)), &_tmp18_);
	_tmp19_ = self->priv->_palette;
	clutter_color_from_string (&_tmp20_, "#ce5c00");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, (gpointer) ((guintptr) ((guint) 1024)), &_tmp20_);
	_tmp21_ = self->priv->_palette;
	clutter_color_from_string (&_tmp22_, "#204a87");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, (gpointer) ((guintptr) ((guint) 2048)), &_tmp22_);
	return self;
}


ColorPalette*
color_palette_new (void)
{
	return color_palette_construct (TYPE_COLOR_PALETTE);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


ColorPalette*
color_palette_get_instance (void)
{
	ColorPalette* result = NULL;
	ColorPalette* _tmp0_;
	ColorPalette* _tmp2_;
	ColorPalette* _tmp3_;
	_tmp0_ = color_palette__singleton;
	if (_tmp0_ == NULL) {
		ColorPalette* _tmp1_;
		_tmp1_ = color_palette_new ();
		_g_object_unref0 (color_palette__singleton);
		color_palette__singleton = _tmp1_;
	}
	_tmp2_ = color_palette__singleton;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void
color_palette_pick_color (ColorPalette* self,
                          guint val,
                          ClutterColor* result)
{
	GeeHashMap* _tmp0_;
	guint norm_val = 0U;
	ClutterColor color = {0};
	GeeHashMap* _tmp5_;
	guint _tmp6_;
	gpointer _tmp7_;
	ClutterColor* _tmp8_;
	ClutterColor _tmp9_;
	guint8 sbits = 0U;
	guint8 _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint8 _tmp13_;
	guint8 _tmp14_;
	guint8 _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_palette;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) val))) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		ClutterColor* _tmp3_;
		ClutterColor _tmp4_;
		_tmp1_ = self->priv->_palette;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) val));
		_tmp3_ = (ClutterColor*) _tmp2_;
		_tmp4_ = *_tmp3_;
		_g_free0 (_tmp3_);
		*result = _tmp4_;
		return;
	}
	norm_val = val / 2048;
	_tmp5_ = self->priv->_palette;
	_tmp6_ = norm_val;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) _tmp6_));
	_tmp8_ = (ClutterColor*) _tmp7_;
	_tmp9_ = *_tmp8_;
	_g_free0 (_tmp8_);
	color = _tmp9_;
	sbits = (guint8) (val % 7);
	_tmp10_ = color.red;
	_tmp11_ = sbits;
	color.red = _tmp10_ << _tmp11_;
	_tmp12_ = color.green;
	_tmp13_ = sbits;
	color.green = _tmp12_ << _tmp13_;
	_tmp14_ = color.blue;
	_tmp15_ = sbits;
	color.blue = _tmp14_ << _tmp15_;
	*result = color;
	return;
}


static void
color_palette_class_init (ColorPaletteClass * klass)
{
	color_palette_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ColorPalette_private_offset);
	G_OBJECT_CLASS (klass)->finalize = color_palette_finalize;
}


static void
color_palette_instance_init (ColorPalette * self)
{
	self->priv = color_palette_get_instance_private (self);
}


static void
color_palette_finalize (GObject * obj)
{
	ColorPalette * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOR_PALETTE, ColorPalette);
	_g_object_unref0 (self->priv->_palette);
	G_OBJECT_CLASS (color_palette_parent_class)->finalize (obj);
}


GType
color_palette_get_type (void)
{
	static volatile gsize color_palette_type_id__volatile = 0;
	if (g_once_init_enter (&color_palette_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ColorPaletteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) color_palette_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ColorPalette), 0, (GInstanceInitFunc) color_palette_instance_init, NULL };
		GType color_palette_type_id;
		color_palette_type_id = g_type_register_static (G_TYPE_OBJECT, "ColorPalette", &g_define_type_info, 0);
		ColorPalette_private_offset = g_type_add_instance_private (color_palette_type_id, sizeof (ColorPalettePrivate));
		g_once_init_leave (&color_palette_type_id__volatile, color_palette_type_id);
	}
	return color_palette_type_id__volatile;
}



