# gnochm.spec
#
# Copyright (c) 2003-2007 Rubens Ramos rubensr@users.sourceforge.net
#
%define name gnochm
%define version 0.9.11
%define release 1fc5

%{?dist: %{expand: %%define %dist 1}}

%define _without_shmime 1
%{?fc3:%undefine _without_shmime}
%{?fc2:%undefine _without_shmime}

# Preamble
Summary: A CHM file viewer for Gnome
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: Applications/Publishing
Source: http://dl.sf.net/gnochm/%{name}-%{version}.tar.gz
URL: http://gnochm.sourceforge.net/
BuildRoot: %{_tmppath}/%{name}-%{version}
BuildArch: noarch
Packager: Rubens Ramos <rubensr@users.sourceforge.net>
Requires: pychm >= 0.8.4
Requires: python
Requires: pygtk2
Requires: pygtk2-libglade
Requires: gnome-python2
Requires: gnome-python2-bonobo
Requires: gnome-python2-gtkhtml2
Requires: gnome-python2-gconf
%{!?_without_shmime:Requires: shared-mime-info}
BuildRequires: pychm >= 0.8.4, python, pygtk2, pygtk2-libglade, gnome-python2
BuildRequires: gnome-python2-bonobo, gnome-python2-gtkhtml2
BuildRequires: gnome-python2-gconf
Prefix: %prefix

%description
A CHM file viewer for Gnome. Features are:
  
  * Full text search
  * Bookmarks
  * Support for external ms-its links
  * Configurable support for http links 
  * Internationalisation
  * Displays HTML page source

# Prep
%prep
%setup

%build
%configure
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
%find_lang %{name}
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

%clean
%{__rm} -rf %{buildroot}

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
export SCHEMA=%{_sysconfdir}/gconf/schemas/gnochm.schemas
gconftool-2 --makefile-install-rule $SCHEMA > /dev/null

scrollkeeper-update -q || :
/usr/bin/update-mime-database %{_datadir}/mime &>/dev/null || :

%postun
scrollkeeper-update -q || :
/usr/bin/update-mime-database %{_datadir}/mime &>/dev/null || :

%files -f %{name}.lang
%defattr(-,root,root,0755)
%doc ABOUT-NLS AUTHORS COPYING ChangeLog NEWS README
%doc %{_datadir}/gnome/help/gnochm/
%config %{_sysconfdir}/gconf/schemas/*.schemas
%{_bindir}/gnochm
%{_datadir}/application-registry/gnochm.*
%{_datadir}/applications/gnochm.desktop
%{_datadir}/gnochm/
%{_datadir}/mime/packages/gnochm.xml
%{_datadir}/mime-info/gnochm.*
%{_datadir}/omf/gnochm/
%{_datadir}/pixmaps/*.png
%{!?_without_shmime:%{_datadir}/mime/application/x-chm.xml}
%{!?_without_shmime:%exclude %{_datadir}/mime/XMLnamespaces}
%{!?_without_shmime:%exclude %{_datadir}/mime/globs}
%{!?_without_shmime:%exclude %{_datadir}/mime/magic}
%exclude %{_localstatedir}/scrollkeeper/
%exclude %{_datadir}/mime/aliases
%exclude %{_datadir}/mime/mime.cache
%exclude %{_datadir}/mime/subclasses

%changelog
* Sat Nov 11 2006 Rubens Ramos <rubensr@users.sourceforge.net>
- Removed man pages because of bug report 1559790

* Tue Nov 09 2004 Rubens Ramos <rubensr@users.sourceforge.net>
- And some more updates from Dag :)

* Sat Nov 06 2004 Rubens Ramos <rubensr@users.sourceforge.net>
- More updates based on Dag's spec for gnochm

* Sat Jan 10 2004 Rubens Ramos <rubensr@users.sourceforge.net>
- Updated copyright and dependencies based on Dag's spec file

* Sun Dec 28 2003 Rubens Ramos <rubensr@users.sourceforge.net>
- After quite some time trying to understand what I 
  actually needed here, things are working. Now gconf stuff seems to
  be installed properly, as well as scrollkeeper docs.
- I guess noarch is better than i386.
- Added a bunch of dependencies
