/*
 * bbc.c - gnews plugin for bbc.co.uk
 * Copyright 2002, Ian Redfern <RedfernI@logica.com>
 *
 * Author:
 *	Ian Redfern <RedfernI@logica.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include        <gmodule.h>
#include        "config.h"
#include        "../include/gnewslib.h"

#define NAME "news.bbc.co.uk"
#define CATEGORY "news"
#define URL "http://tickers.bbc.co.uk/tickerdata/story2.dat"
#define TITLEBG 0xEEEEEE;
#define TITLEFG 0x0044DE;
#define DESCBG 0xFFFFFF;
#define DESCFG 0x000000;

gchar *last_title = NULL;

G_MODULE_EXPORT gchar *
gnews_plugin_get_name (void)
{
  return (g_strdup (NAME));
}

G_MODULE_EXPORT gchar *
gnews_plugin_get_category (void)
{
  return (g_strdup (CATEGORY));
}

G_MODULE_EXPORT gchar *
gnews_plugin_get_url (void)
{
  return (g_strdup (URL));
}

static void
correct_fields (gpointer data, gpointer user_data)
{
  rdfitem *rdf;
  char *skip;

  rdf = data;
  rdf->title = g_strdup (NAME);
  // Remove leading word
  skip = strchr(rdf->description, ' ')+1;
  memmove(rdf->description, skip, strlen(skip)+1);
  skip = strchr(rdf->link, ' ')+1;
  memmove(rdf->link, skip, strlen(skip)+1);
}

G_MODULE_EXPORT sitedata *
gnews_plugin_get_headlines (void)
{
  sitedata *sd;
  GSList *last;
  rdfitem *lastitem;
  gchar *content;
  char *story_start, *story_end;

  sd = g_malloc (sizeof (sitedata));
  content = http_get_url (URL);

  // Remove blank stories
  story_start = content;
  while(story_start = strstr(story_start, "\nSTORY "))
  {
      if (strstr(story_start, "\nURL ") == strstr(story_start, "\nURL \n"))
      {
	  // We have no link - let's remove
	  story_end = strstr(story_start+1, "\nSTORY ");
	  if (!story_end)
	  {
	      // Make it terminate here
	      *story_start = 0;
	      break;
	  }
	  else
	  {
	      // Move everything along to close it up
	      memmove(story_start, story_end, strlen(story_end)+1);
	      continue;
	  }
      }
      story_start++;      
  }

  sd->headlines = gnews_parse_txt (content, "\n", 3, 5, 1, 1, 1, 1, 2);
  g_free (content);
  sd->has_new = FALSE;
  if (sd->headlines != NULL) {
    last = g_slist_last (sd->headlines);
    lastitem = last->data;
    if (last_title != NULL) {
      if (strcmp (lastitem->title, last_title) != 0) {
	sd->has_new = TRUE;
	g_free (last_title);
	last_title = g_strdup (lastitem->title);
      }
    } else {
      last_title = g_strdup (lastitem->title);
    }
  }

  g_slist_foreach (sd->headlines, correct_fields, NULL);
  sd->name = g_strdup (NAME);
  sd->titlebg = TITLEBG;
  sd->titlefg = TITLEFG;
  sd->descriptionbg = DESCBG;
  sd->descriptionfg = DESCFG;

  return (sd);
}
