/*
 * libgnews.c - libgnews generic functions
 * Copyright 2000-2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <gnome-xml/parser.h>
#include "../include/gnewslib.h"

#if 0
static void
slist_append_one (gpointer data, gpointer user_data)
{
  GSList *target;

  target = user_data;
  target = g_slist_append (target, data);
}


GSList *
g_slist_merge (GSList * a, GSList * b)
{
  if (b != NULL) {
    g_slist_foreach (b, slist_append_one, a);
  }

  return (a);
}
#endif


gint
str_count (gchar ** strings)
{
  gint count = 0;

  if (strings != NULL) {
    while (strings[count] != NULL) {
      count++;
    }
  }
  return (count);
}


GSList *
gnews_parse_txt (gchar * text, gchar * separator, gint recordlen,
		 gint prefix, gint titlerow, gint titlerows,
		 gint descriptionrow, gint descriptionrows, gint linkrow)
{
  gchar **records;
  gchar *oldstr, *tmpstr;
  gint recordcount, i, j;
  rdfitem *item;
  GSList *items = NULL;

  if (!isemptystr (text) && (!isemptystr (separator))) {
    records = g_strsplit (text, separator, 0);
    recordcount = str_count (records);
    for (i = 0 + prefix; i < recordcount; i += recordlen) {
      item = g_malloc (sizeof (rdfitem));
      item->title = NULL;
      item->link = NULL;
      item->description = NULL;
      if (titlerows > 0) {
	item->title = g_strdup ("");
      }
      for (j = titlerow; j < titlerow + titlerows; j++) {
	oldstr = item->title;
	item->title = g_strconcat (item->title, records[i + j], NULL);
	g_free (oldstr);
      }
      if (descriptionrows > 0) {
	item->description = g_strdup ("");
      }
      for (j = descriptionrow; j < descriptionrow + descriptionrows; j++) {
	oldstr = item->description;
	item->description = g_strconcat (item->description, records[i + j], NULL);
	g_free (oldstr);
      }
      item->link = g_strdup (records[i + linkrow]);
      items = g_slist_append (items, item);
    }
    g_strfreev (records);
  }

  return (items);
}

static xmlNodePtr
find_channel_node (xmlNodePtr node)
{
  xmlNodePtr foundnode = NULL;

  while ((node != NULL) && (foundnode == NULL)) {
    if (strcmp (node->name, "channel") == 0) {
      foundnode = node->childs;
    }
  }

  return (foundnode);
}

static GSList *
parse_rdf_rss (gchar * text, gboolean have_channel)
{
  xmlDocPtr doc;
  xmlNodePtr node, pnode;
  rdfitem *item;
  GSList *items = NULL;

  if (!isemptystr (text)) {
    doc = xmlParseMemory (text, strlen (text));
    pnode = (doc != NULL ? doc->root->childs : NULL);
    if (have_channel) {
      pnode = find_channel_node (pnode);
    }
    while (pnode != NULL) {
      if (strcmp (pnode->name, "item") == 0) {
	item = g_malloc (sizeof (rdfitem));
	item->title = NULL;
	item->link = NULL;
	item->description = NULL;

	node = pnode->childs;
	while (node != NULL) {
	  if (strcmp (node->name, "title") == 0) {
	    item->title = g_strdup (node->childs->content);
	  } else if (strcmp (node->name, "link") == 0) {
	    item->link = g_strdup (node->childs->content);
	  } else if (strcmp (node->name, "description") == 0) {
	    item->description = g_strdup (node->childs->content);
	  }
	  node = node->next;
	}

	items = g_slist_append (items, item);
      }
      pnode = pnode->next;
    }
    xmlFreeDoc (doc);
  }

  return (items);
}

GSList *
gnews_parse_rdf (gchar * text)
{
  return (parse_rdf_rss (text, FALSE));
}

GSList *
gnews_parse_rss (gchar * text)
{
  return (parse_rdf_rss (text, TRUE));
}
