/*
 * http.c - libgnews http functions
 * Copyright 2000-2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "../include/gnewslib.h"

static gboolean use_proxy;
static gchar *proxy_url;
static gchar *proxy_user;
static gchar *proxy_passwd;

void
set_http_options (gboolean use_p, gchar * p_url, gchar * p_user, gchar * p_passwd)
{
  if (use_p) {
    proxy_url = p_url;
    proxy_user = p_user;
    proxy_passwd = p_passwd;
  }
  use_proxy = use_p;
}

gchar *
http_get_url (gchar * url)
{
  ghttp_request *rq;
  ghttp_status st = ghttp_not_done;
  gchar *body = NULL;
  gint body_len;

  rq = ghttp_request_new ();
  if (ghttp_set_uri (rq, url) != -1) {
    if (use_proxy) {
      ghttp_set_proxy (rq, proxy_url);
      ghttp_set_proxy_authinfo (rq, proxy_user, proxy_passwd);
    }
    ghttp_set_header (rq, http_hdr_Connection, "close");
    ghttp_prepare (rq);
    ghttp_set_sync (rq, ghttp_async);
    st = ghttp_process (rq);
    while (st == ghttp_not_done) {
      st = ghttp_process (rq);
    }
    if (st == ghttp_done) {
      if (ghttp_status_code (rq) == 200) {
	body = g_strdup (ghttp_get_body (rq));
	body_len = ghttp_get_body_len (rq);
/*	if (body_len>0){
	  while ((body[body_len]!='\n')&&(body_len>0)){
	    body_len--;
	  }
	  body[body_len] = 0;  
	}*/
      }
    }
  }
  ghttp_clean (rq);
  g_free (rq);

  return (body);
}
