/*
 * plugins.h - gnews plugin functions include
 * Copyright 2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef		__PLUGINS_H_
#define		__PLUGINS_H_

#include <glib.h>
#include <gmodule.h>
#include "../include/gnewslib.h"

typedef void (*SimpleFunc) (void);
typedef gchar *(*GCharFunc) (void);
typedef void (*GModuleFunc) (GModule *);
typedef GSList *(*GSListFunc) (void);
typedef sitedata *(*SiteDataFunc) (void);

typedef struct _plugindef plugindef;
struct _plugindef {
  GModule *module;
  GCharFunc get_name;
  GCharFunc get_category;
  GCharFunc get_url;
  SiteDataFunc get_headlines;
};

GSList *load_all_plugins (void);
GSList *load_some_plugins (gchar ** files);
void unload_plugins (GSList * plugins);
void debug_plugins (GSList * plugins);

#endif
