//#include <gtk/gtk.h>

#ifndef __UI_H
#define __UI_H

#include "menu.h"

#include "searchtab.h"
#include "browsetab.h"
#include "downloadtab.h"
#include "uploadtab.h"
#include "consoletab.h"
#include "motdtab.h"

#define DEFAULT_WIDTH 	690
#define DEFAULT_HEIGHT	355

#define COLOR_MOD(x,y) x += (x > 0xf000) ? -y : y;

#ifdef HAVE_GNOME
#define DIALOG_YES GNOME_YES
#define DIALOG_NO GNOME_NO
#else
#define DIALOG_YES 1
#define DIALOG_NO 0
#endif /* HAVE_GNOME */

#define j_box_pack(b,w,x,y,z) \
        gtk_box_pack_start(GTK_BOX(b),w,x,y,z)

#define CLIST_LENGTH(x) g_list_length(GTK_CLIST(x)->row_list)

struct _WidgetProperty {
   int type;
   char *conf;
   int key;
   GList *sensitive;
};

struct _GnapsterMain {
   int type;
   
   GList *sresults;	/* search strings */
   GList *sdata;	/* search results themselves */
   
   unsigned short port;
   int bind_sock;
   int bind_input;
   
   GtkWidget *window;
   GtkWidget *notebook;
   GtkWidget *srv_notebook;
   GtkWidget *appbar;
#ifndef HAVE_GNOME
   GtkWidget *vbox;
   GtkWidget *menubar;
#endif /* !HAVE_GNOME */
   GtkProgress *progress;
   GtkStyle *normal;
   GtkStyle *highlight;
   
   SearchTab *st;
   BrowseTab *bt;
   DownloadTab *dt;
   UploadTab *ut;
   
   int safe_exit;
   
   time_t clistart;	/* time of the client start */
   
   float in;		/* total ingoing transfers size (MB) */
   float out;   	/* total outgoing transfers size (MB) */
   
   int appbar_timeout;
};

struct _ChannelTab {
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *text;
   GtkWidget *label;
   GtkWidget *scroller;
   GtkWidget *scroller2;
   GtkWidget *hide_list;
   GtkWidget *clist;
   char *channel;
};

struct _PropDlg {
   GtkWidget *window;
   GtkWidget *frame;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   GtkWidget *accounts;
   GtkWidget *nap_port;
   GtkWidget *connection;
   GtkWidget *download_dir;
   GtkWidget *exec_dl_optn;
   GtkWidget *exec_dl;
   GtkWidget *upload_dir;
   GtkWidget *share_paths;
   GtkWidget *build_list;
   GtkWidget *add_share;
   GtkWidget *rem_share;
   GtkWidget *update_list;
   GtkWidget *autoquery;
   GtkWidget *name_fix;
   GtkWidget *hide_joinpart;
   GtkWidget *hide_users;
   GtkWidget *theme_colors;
   GtkWidget *auto_rm;
   GtkWidget *opennap_server;
   GtkWidget *server_entry;
   GtkWidget *auto_start_queue;
   GtkWidget *reject_ul;
   GtkWidget *firewall;
   GtkWidget *socks_firewall;
   GtkWidget *socks_server;
   GtkWidget *socks_port;
   GtkWidget *socks4;
   GtkWidget *socks5;
   GtkWidget *socks5_username;
   GtkWidget *socks5_password;
   GtkWidget *aj_entry;
   GtkWidget *aj_add;
   GtkWidget *aj_remove;
   GtkWidget *aj_clist;
   GtkWidget *logging;
   GtkWidget *font_entry;
   GtkWidget *font_browse;
   GtkWidget *trans;
   GtkWidget *update_tint;
   GtkWidget *tint_red, *tint_green, *tint_blue;
   GtkWidget *curr_theme;
   GtkWidget *themes;
   GtkWidget *bw_down;
   GtkWidget *bw_up;
   GtkWidget *timestamp;
   int calling;
#ifndef HAVE_GNOME
   GtkWidget *notebook;
#endif
   GtkWidget *scroller;
};

struct _BuildDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   int pipe_input;
   int cpid;
};

struct _BrowseDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   GtkWidget *ctree;
   GtkWidget *clist;
   GtkWidget *add;
   GtkWidget *accounts;
   GtkWidget *edit;
   GtkWidget *delete;
   int show_network_id;
   GtkWidget *refresh;
   GtkWidget *trefresh;
   GtkWidget *scroller;
   GtkWidget *account;
};

struct _RefreshDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
};

struct _EditDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   GtkWidget *server;
   GtkWidget *port;
   GtkWidget *desc;
   GtkWidget *network;
};

struct _AddDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   GtkWidget *server;
   GtkWidget *port;
   GtkWidget *desc;
   GtkWidget *network;
};

struct _ListChanDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   GtkWidget *scroller;
   GtkWidget *clist;
};

struct _ResumeDlg {
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *label;
   GtkWidget *scroller;
   GtkWidget *clist;
};

struct _STab {
   int type;
   
   GtkWidget *notebook;
   GtkWidget *vbox;
   
   /* property bound widgets */
   GList *pwidgets;
   
   /* search data */
   char *lsearch;
   GList *ls;
   GList *sresults;
   
   /* which server notebook page are we attached to? */
   int pn;
   
   ConnInfo *ci;
   SearchTab *st;
   BrowseTab *bt;
   DownloadTab *dt;
   UploadTab *ut;
   ConsoleTab *ct;
   MOTDTab *mt;
};

/* prototypes */
void entry_set_text(GtkWidget *w, char *fmt, ...);
void configure_event(GtkWidget *w, GdkEventConfigure *e, GtkWidget *text);
void notebook_set_sensitive(GtkWidget *notebook, int pn, int sens);
void notebook_set_label(GtkWidget *notebook, int pn, char *text);
void search_sort_results(GtkWidget *w);
STab *console_tab_notebook(GtkWidget *widget);
int search_tab_clist(GtkWidget *widget);
int is_queue_clist(GtkWidget *widget);
int is_browse_ctree(GtkWidget *widget);
void set_clist_server(GtkWidget *w, STab *stab, int row);
void set_green_style(GtkWidget *w, int row, int col);
int dialog_open(GtkWidget *window);
GtkWidget *j_label_new(GtkWidget *box, char *s);
GtkWidget *j_line_new(GtkWidget *w, int i1, int i2);
GtkWidget *j_combo_new(int type, ...);
GtkWidget *create_gnapster_tab(char *label, char *stock);
void unhook_configure_event(GtkWidget *w, void *data);
void hook_configure_event(GtkWidget *w, GtkWidget *text);
void j_dialog_close_cb(GtkWidget *w, void *data);
void build_links(GtkWidget *ctree, GList *links);
void create_server_links(STab *stab);
void xfer_close(GtkWidget *w, void *data);
GtkWidget *create_xfer_stats(STab *stab);
void create_gnapster_main();
void create_stab();
void remove_stab();
STab *append_server_tab();
int reorganize_stab();
void remove_server_tab(STab *stab);
void accounts_dlg_close(GtkWidget *button, void *data);
void fill_accounts(GtkWidget *w, int combo);
void create_accounts_cb(GtkWidget *w, void *data);
GtkWidget *prop_entry_new(char *key, int *value);
void create_prop_dlg(void *changed_cb, void *button_cb, void *destroy_cb, void *clicked_cb, int *new_user_val);
void create_build_dlg();
void create_browse_dlg();
void create_refresh_dlg();
void create_add_dlg();
void create_edit_dlg(Server *nsrv, char *desc);
void create_list_chan_dlg();
void create_resume_dlg();
/* !prototypes */


#endif /* __UI_H */
