#ifndef __TYPES_H
#define __TYPES_H

/* Don't question my reason for doing this... ;) */

/* types.pl */
typedef enum _TransferInfo TransferInfo;
/*typedef struct _Command Command;*/
/*typedef struct _SPack SPack;*/
typedef struct _SocksData SocksData;
typedef struct _DialogRunInfo DialogRunInfo;
typedef struct _Key Key;
typedef struct _ConfigTable ConfigTable;
typedef struct _FreeTable FreeTable;
typedef struct _HookTable HookTable;
typedef struct _Type Type;
typedef struct _Theme Theme;
typedef struct _ThemeHook ThemeHook;
typedef struct _FileEntry FileEntry;
typedef struct _ChannelInfo ChannelInfo;
typedef struct _UserInfo UserInfo;
typedef struct _Transfer Transfer;
typedef struct _Search Search;
typedef struct _Server Server;
typedef struct _File File;
typedef struct _User User;
typedef struct _Channel Channel;
typedef struct _Resume Resume;
typedef struct _NBRead NBRead;
typedef struct _Packet Packet;
typedef struct _ConnInfo ConnInfo;
typedef struct _WidgetProperty WidgetProperty;
typedef struct _GnapsterMain GnapsterMain;
typedef struct _SearchTab SearchTab;
typedef struct _BrowseTab BrowseTab;
typedef struct _DownloadTab DownloadTab;
typedef struct _UploadTab UploadTab;
typedef struct _ConsoleTab ConsoleTab;
typedef struct _ChannelTab ChannelTab;
typedef struct _MOTDTab MOTDTab;
typedef struct _PropDlg PropDlg;
typedef struct _BuildDlg BuildDlg;
typedef struct _BrowseDlg BrowseDlg;
typedef struct _RefreshDlg RefreshDlg;
typedef struct _EditDlg EditDlg;
typedef struct _AddDlg AddDlg;
typedef struct _ListChanDlg ListChanDlg;
typedef struct _ResumeDlg ResumeDlg;
typedef struct _STab STab;
typedef struct _Connection Connection;
typedef struct _CBPack CBPack;
typedef struct _Account Account;
typedef struct _LinkedCommand LinkedCommand;
/* !types.pl */

#define OPENNAP_MASK    (0xffff0000)
#define CANCELS_MASK    (0x0000ff00)
#define SHARING_MASK    (0x40)
#define DEBUG_MASK      (0x20)
#define CONNECTED_MASK  (0x10)
#define CONNECTING_MASK (0x08)
#define SEARCHING_MASK  (0x04)
#define BROWSING_MASK   (0x02)
#define SAFE_EXIT_MASK  (0x01)

struct _ConnInfo {
   int type;
  
   /* 0000 0000 0010 0111 0000 0000 0101 0000 */
   /* AAAA AAAA AAAA AAAA BBBB BBBB 0YXC DEFG */
   /* A - opennap version 
      B - cancels
      C - connected
      D - connecting
      E - searching
      F - browsing
      G - safe exit 
      X - debug
      Y - sharing */
   guint32 state;

   /* main server connection */
   int sock;
   int sock_input;
   
   /* bind handling */
/*   int bind_sock;
   int bind_sock_input;*/
   
   /* uploading */
   int upload_input;
   
   /* browse opennap refresh */
   int napigator_sock;
   int napigator_input;
   
   /* statusbar state */
   char *status;
   char astatus;
   
   /* account */
   Account *account;
   
   /* "last" server */
   char *server; /* hostname */
   char *ip;
   int port;

   /* current stats */
   unsigned short users;
   unsigned long songs;
   unsigned short gigs;
   
   /* regexp to grep for bans in the banlist */
   char *ban_exp;

   /* last seen packet */
   Packet *cp;

   /* total sharing */
   int sharing;              /* files shared */
   unsigned long share_size; /* kilobytes */
   
   /* total bandwidth usage */
   unsigned long download_size; /* kilobytes */
   unsigned long upload_size;   /* kilobytes */
   
   float download_kps;		/* avg k/s */
   float upload_kps;		/* avg k/s */
   unsigned long download_xfers;
   unsigned long upload_xfers;
   
   /* reconnection to "last" server */
   int reconnect_timeout;
};

typedef enum {
   TRANSFER, N_SEARCH, SERVER, N_USER, N_CHAN_INFO,
   N_RESUME, W_PROP, HOOK, THEME, FILE_ENTRY,
   SEARCH_TAB, BROWSE_TAB, DOWNLOAD_TAB, UPLOAD_TAB, CONSOLE_TAB, MOTD_TAB,
   STAB, SPACK, CONN_INFO, GMAIN, CBPACK, ACCOUNT, SHARE, CONNECTION
} StructType;

#endif /* __TYPES_H */
