#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>

#include "gnapster.h"
#include "upload.h"
#include "commands.h"
#include "download.h"
#include "queue.h"
#include "resume.h"

extern ResumeDlg resume_dlg;
extern BrowseDlg browse_dlg;

void modify_resume_entry(char *newpath, Transfer *download) {
   FILE *f;
   char *file, *size, *checksum, *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   unsigned long rsize;
   
   f = open_resume("r");
   if (!f)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   f = open_resume("w");
   if (!f)
     return;
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      file = next_arg(dptr, &dptr);
      size = next_arg(dptr, &dptr);
      checksum = next_arg_full(dptr, &dptr, '-');
      convert(next_arg(dptr, &dptr), "%lu", &rsize);
      
      NA_ERR_HANDLE_CONTINUE();
      
      if (!strcmp(checksum, download->id) && download->total == rsize)
	fprintf(f, "\"%s\" %lu %s-%lu\n", newpath, download->size, checksum,
		rsize);
      else
	fprintf(f, "\"%s\" %s %s-%lu\n", file, size, checksum, rsize);
   }
   
   read_file_free(felem);
   
   fclose(f);
}

void remove_resume_entry(Transfer *download) {
   FILE *f;
   char *file, *size, *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   char *checksum;
   unsigned long int rsize;
   
   f = open_resume("r");
   if (!f)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   f = open_resume("w");
   if (!f)
     return;
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      file = next_arg(dptr, &dptr);
      size = next_arg(dptr, &dptr);
      checksum = next_arg_full(dptr, &dptr, '-');
      convert(next_arg(dptr, &dptr), "%lu", &rsize);
      
      NA_ERR_HANDLE_CONTINUE();
      
      /* this statement will fail if id and size are the same */
      if (strcmp(checksum, download->id) && download->total != rsize)
	fprintf(f, "\"%s\" %s %s-%lu\n", file, size, checksum, rsize);
   }
   
   read_file_free(felem);
   
   fclose(f);
}

void append_resume_entry(Transfer *download) {
   FILE *f;
   char *file, *size, *dptr, *checksum;
   GList *ptr, *felem;
   FileEntry *fent;
   int rsize, x = 0;
   
   f = open_resume("r");
   if (f) {
      felem = read_file(f);

      fclose(f);

      for(ptr=felem; ptr; ptr=ptr->next) {
	 fent = ptr->data;
	 if (!fent)
	   continue;
	 
	 dptr = fent->lptr;

	 file = next_arg(dptr, &dptr);
	 size = next_arg(dptr, &dptr);
	 checksum = next_arg_full(dptr, &dptr, '-');
	 convert(next_arg(dptr, &dptr), "%lu", &rsize);
	 
	 NA_ERR_HANDLE_CONTINUE();
	 
	 if (!strcmp(checksum, download->id) && rsize == download->total)
	   x = 1;
	 
	 if (x)
	   break;
      }

      read_file_free(felem);
      
      /* if we matched it already, don't add it again */
      if (x)
	return;
   }
   
   f = open_resume("a");
   if (!f)
     return;
   
   fprintf(f, "\"%s\" %lu %s-%lu\n", download->fpath, download->size,
	     download->id, download->total);
   
   fclose(f);
}

void resume_dlg_clist_cb() {
}

void resume_dlg_cb(GtkWidget *w, gpointer data) {
/*   char *s;
   
   if (!data)
     return;
   
   s = (char *)data;
   
   if (!strcmp(s, "resume")) {
      Resume *temp;
      
      temp = gnapster_get_selection_data(resume_dlg.clist, NULL);
      if (!temp)
	return;
      
      napster_send(conn_info.sock, NAPSTER_RESUME_SEARCH, "%s-%lu %lu",
		   temp->checksum, temp->remotesize, temp->remotesize);
      
      conn_info.state |= SEARCHING_MASK;
      
      gtk_clist_clear(GTK_CLIST(search_tab.clist));
      gtk_clist_freeze(GTK_CLIST(search_tab.clist));
      gtk_entry_set_editable(GTK_ENTRY(search_tab.gtk_entry), 0);
   } else if (!strcmp(s, "remove")) {
      Resume *temp;
      Transfer *download;
      
      temp = gnapster_get_selection_data(resume_dlg.clist, NULL);
      if (!temp)
	return;
      
      download = d_new(TRANSFER);
      
      download->total = temp->remotesize;
      download->id = d_strdup(temp->checksum);
      
      remove_resume_entry(download);
      
      d_free(download);
      
      populate_resume_dlg();
      
      return;
   }
   
   j_dialog_close(resume_dlg.window);
   resume_dlg.window = NULL;*/
}

void populate_resume_dlg() {
   FILE *f;
   char *file, *size, *md5, *checksum, *tf, *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   Resume *resume;
   int rsize;
   
   f = open_resume("r");
   if (!f)
     return;
   
   gtk_clist_freeze(GTK_CLIST(resume_dlg.clist));
   gtk_clist_clear(GTK_CLIST(resume_dlg.clist));
   
   felem = read_file(f);
   
   fclose(f);
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      file = next_arg(dptr, &dptr);
      size = next_arg(dptr, &dptr);
      md5 = next_arg(dptr, &dptr);
      
      NA_ERR_HANDLE_CONTINUE();
      
      checksum = next_arg_full(md5, &md5, '-');
      rsize = my_atoi(next_arg(md5, &md5));
      
      NA_ERR_HANDLE_CONTINUE();
      
      resume = d_new(N_RESUME);

      resume->file = d_strdup(file);
      resume->checksum = d_strdup(checksum);
      resume->remotesize = rsize;
      
      tf = strrchr(resume->file, '/');
      if (tf)
	tf++;
      
      gnapster_clist_append(resume_dlg.clist, NULL, resume, tf, 
			    simplify_size(resume->remotesize), NULL);
   }
   
   read_file_free(felem);

   gtk_clist_thaw(GTK_CLIST(resume_dlg.clist));
}

void resume_download_cb() {
   j_warning_dialog("Resume searches have been disabled server side on all known servers.\nTo resume with Gnapster simply find a file of the same size from a search/browse and download it");
/*   if (dialog_open(resume_dlg.window))
     return;
   
   create_resume_dlg();
   populate_resume_dlg();*/
}

FILE *open_resume(char *flags) {
   FILE *f;
   char *conf;
   
   conf = local_path("resume", NULL);
   
   f = fopen(conf, flags);
   
   if (!f)
     j_error("fopen", conf, NULL);
   
   d_free(conf);
   
   return f;
}
